package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTunisia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇳",
        description = "flag: Tunisia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-tunisia", "tunisia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Tunisia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTunisia: Emoji get() = _FlagTunisia

/**
 * Alias to emoji [FlagTunisia] (Flags: country-flag: flag: Tunisia).
*/
public val Emoji.Companion.TunisiaFlag: Emoji get() = _FlagTunisia
