package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FilmProjector: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📽️",
        description = "film projector",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("film-projector", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: light & video: film projector.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FilmProjector: Emoji get() = _FilmProjector
