package org.kodein.emoji.people_body.hand_single_finger

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _IndexPointingAtTheViewer: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🫵",
        description = "index pointing at the viewer",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("index-pointing-at-the-viewer", "pointing"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-single-finger: index pointing at the viewer.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.IndexPointingAtTheViewer: SkinTone1Emoji get() = _IndexPointingAtTheViewer

/**
 * Alias to emoji [IndexPointingAtTheViewer] (People & Body: hand-single-finger: index pointing at the viewer).
*/
public val Emoji.Companion.Pointing: SkinTone1Emoji get() = _IndexPointingAtTheViewer
