package org.kodein.emoji.smileys_emotion.face_affection

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _StarStruck: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤩",
        description = "star-struck",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("star-struck", ),
        emoticons = listOf("*_*"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-affection: star-struck.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.StarStruck: Emoji get() = _StarStruck
