package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithOpenMouth: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😮",
        description = "face with open mouth",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("face-with-open-mouth", "mouth-open"),
        emoticons = listOf(":O"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: face with open mouth.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithOpenMouth: Emoji get() = _FaceWithOpenMouth

/**
 * Alias to emoji [FaceWithOpenMouth] (Smileys & Emotion: face-concerned: face with open mouth).
*/
public val Emoji.Companion.MouthOpen: Emoji get() = _FaceWithOpenMouth
