package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap0: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "0️⃣",
        description = "keycap: 0",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-0", "zero", "keycap-zero"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 0.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap0: Emoji get() = _Keycap0

/**
 * Alias to emoji [Keycap0] (Symbols: keycap: keycap: 0).
*/
public val Emoji.Companion.Zero: Emoji get() = _Keycap0

/**
 * Alias to emoji [Keycap0] (Symbols: keycap: keycap: 0).
*/
public val Emoji.Companion.KeycapZero: Emoji get() = _Keycap0
