package org.kodein.emoji.symbols.transport_sign

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BabySymbol: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚼",
        description = "baby symbol",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("baby-symbol", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: transport-sign: baby symbol.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BabySymbol: Emoji get() = _BabySymbol
