package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllEvent() {
    add(intArrayOf(0x1f383), _JackOLantern)
    add(intArrayOf(0x1f384), _ChristmasTree)
    add(intArrayOf(0x1f386), _Fireworks)
    add(intArrayOf(0x1f387), _Sparkler)
    add(intArrayOf(0x1f9e8), _Firecracker)
    add(intArrayOf(0x2728), _Sparkles)
    add(intArrayOf(0x1f388), _Balloon)
    add(intArrayOf(0x1f389), _PartyPopper)
    add(intArrayOf(0x1f38a), _ConfettiBall)
    add(intArrayOf(0x1f38b), _TanabataTree)
    add(intArrayOf(0x1f38d), _PineDecoration)
    add(intArrayOf(0x1f38e), _JapaneseDolls)
    add(intArrayOf(0x1f38f), _CarpStreamer)
    add(intArrayOf(0x1f390), _WindChime)
    add(intArrayOf(0x1f391), _MoonViewingCeremony)
    add(intArrayOf(0x1f9e7), _RedEnvelope)
    add(intArrayOf(0x1f380), _Ribbon)
    add(intArrayOf(0x1f381), _WrappedGift)
    add(intArrayOf(0x1f397, 0xfe0f), _ReminderRibbon)
    add(intArrayOf(0x1f397), _ReminderRibbon)
    add(intArrayOf(0x1f39f, 0xfe0f), _AdmissionTickets)
    add(intArrayOf(0x1f39f), _AdmissionTickets)
    add(intArrayOf(0x1f3ab), _Ticket)
}

internal suspend fun SequenceScope<Emoji>.yieldAllEvent() {
    yield(_JackOLantern)
    yield(_ChristmasTree)
    yield(_Fireworks)
    yield(_Sparkler)
    yield(_Firecracker)
    yield(_Sparkles)
    yield(_Balloon)
    yield(_PartyPopper)
    yield(_ConfettiBall)
    yield(_TanabataTree)
    yield(_PineDecoration)
    yield(_JapaneseDolls)
    yield(_CarpStreamer)
    yield(_WindChime)
    yield(_MoonViewingCeremony)
    yield(_RedEnvelope)
    yield(_Ribbon)
    yield(_WrappedGift)
    yield(_ReminderRibbon)
    yield(_AdmissionTickets)
    yield(_Ticket)
}

internal val countEvent = 21

/**
 * All Emoji of the Activities: event subgroup.
*/
public fun Emoji.Companion.sequenceEvent(): Sequence<Emoji> =
    sequence { yieldAllEvent() }

/**
 * All Emoji of the Activities: event subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listEvent(): List<Emoji> =
    ArrayList<Emoji>(countEvent).also { list -> sequenceEvent().forEach { list.add(it) } }

@Deprecated("Renamed listEvent.", replaceWith = ReplaceWith("listEvent()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allEvent(): List<Emoji> =
    listEvent()
