package org.kodein.emoji.animals_nature.animal_amphibian

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAnimalAmphibian() {
    add(intArrayOf(0x1f438), _Frog)
}

internal suspend fun SequenceScope<Emoji>.yieldAllAnimalAmphibian() {
    yield(_Frog)
}

internal val countAnimalAmphibian = 1

/**
 * All Emoji of the Animals & Nature: animal-amphibian subgroup.
*/
public fun Emoji.Companion.sequenceAnimalAmphibian(): Sequence<Emoji> =
    sequence { yieldAllAnimalAmphibian() }

/**
 * All Emoji of the Animals & Nature: animal-amphibian subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listAnimalAmphibian(): List<Emoji> =
    ArrayList<Emoji>(countAnimalAmphibian).also { list -> sequenceAnimalAmphibian().forEach { list.add(it) } }

@Deprecated("Renamed listAnimalAmphibian.", replaceWith = ReplaceWith("listAnimalAmphibian()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allAnimalAmphibian(): List<Emoji> =
    listAnimalAmphibian()
