package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAscensionIsland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇨",
        description = "flag: Ascension Island",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-ascension-island", "ascension-island-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Ascension Island.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAscensionIsland: Emoji get() = _FlagAscensionIsland

/**
 * Alias to emoji [FlagAscensionIsland] (Flags: country-flag: flag: Ascension Island).
*/
public val Emoji.Companion.AscensionIslandFlag: Emoji get() = _FlagAscensionIsland
