package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagStLucia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇨",
        description = "flag: St. Lucia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-st-lucia", "st-lucia-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: St. Lucia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagStLucia: Emoji get() = _FlagStLucia

/**
 * Alias to emoji [FlagStLucia] (Flags: country-flag: flag: St. Lucia).
*/
public val Emoji.Companion.StLuciaFlag: Emoji get() = _FlagStLucia
