package org.kodein.emoji.flags.flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CrossedFlags: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎌",
        description = "crossed flags",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("crossed-flags", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: flag: crossed flags.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CrossedFlags: Emoji get() = _CrossedFlags
