package org.kodein.emoji.food_drink.food_fruit

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFoodFruit() {
    add(intArrayOf(0x1f347), _Grapes)
    add(intArrayOf(0x1f348), _Melon)
    add(intArrayOf(0x1f349), _Watermelon)
    add(intArrayOf(0x1f34a), _Tangerine)
    add(intArrayOf(0x1f34b), _Lemon)
    add(intArrayOf(0x1f34b, 0x200d, 0x1f7e9), _Lime)
    add(intArrayOf(0x1f34c), _Banana)
    add(intArrayOf(0x1f34d), _Pineapple)
    add(intArrayOf(0x1f96d), _Mango)
    add(intArrayOf(0x1f34e), _RedApple)
    add(intArrayOf(0x1f34f), _GreenApple)
    add(intArrayOf(0x1f350), _Pear)
    add(intArrayOf(0x1f351), _Peach)
    add(intArrayOf(0x1f352), _Cherries)
    add(intArrayOf(0x1f353), _Strawberry)
    add(intArrayOf(0x1fad0), _Blueberries)
    add(intArrayOf(0x1f95d), _KiwiFruit)
    add(intArrayOf(0x1f345), _Tomato)
    add(intArrayOf(0x1fad2), _Olive)
    add(intArrayOf(0x1f965), _Coconut)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFoodFruit() {
    yield(_Grapes)
    yield(_Melon)
    yield(_Watermelon)
    yield(_Tangerine)
    yield(_Lemon)
    yield(_Lime)
    yield(_Banana)
    yield(_Pineapple)
    yield(_Mango)
    yield(_RedApple)
    yield(_GreenApple)
    yield(_Pear)
    yield(_Peach)
    yield(_Cherries)
    yield(_Strawberry)
    yield(_Blueberries)
    yield(_KiwiFruit)
    yield(_Tomato)
    yield(_Olive)
    yield(_Coconut)
}

internal val countFoodFruit = 20

/**
 * All Emoji of the Food & Drink: food-fruit subgroup.
*/
public fun Emoji.Companion.sequenceFoodFruit(): Sequence<Emoji> =
    sequence { yieldAllFoodFruit() }

/**
 * All Emoji of the Food & Drink: food-fruit subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFoodFruit(): List<Emoji> =
    ArrayList<Emoji>(countFoodFruit).also { list -> sequenceFoodFruit().forEach { list.add(it) } }

@Deprecated("Renamed listFoodFruit.", replaceWith = ReplaceWith("listFoodFruit()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFoodFruit(): List<Emoji> =
    listFoodFruit()
