package org.kodein.emoji.food_drink.food_prepared

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFoodPrepared() {
    add(intArrayOf(0x1f35e), _Bread)
    add(intArrayOf(0x1f950), _Croissant)
    add(intArrayOf(0x1f956), _BaguetteBread)
    add(intArrayOf(0x1fad3), _Flatbread)
    add(intArrayOf(0x1f968), _Pretzel)
    add(intArrayOf(0x1f96f), _Bagel)
    add(intArrayOf(0x1f95e), _Pancakes)
    add(intArrayOf(0x1f9c7), _Waffle)
    add(intArrayOf(0x1f9c0), _CheeseWedge)
    add(intArrayOf(0x1f356), _MeatOnBone)
    add(intArrayOf(0x1f357), _PoultryLeg)
    add(intArrayOf(0x1f969), _CutOfMeat)
    add(intArrayOf(0x1f953), _Bacon)
    add(intArrayOf(0x1f354), _Hamburger)
    add(intArrayOf(0x1f35f), _FrenchFries)
    add(intArrayOf(0x1f355), _Pizza)
    add(intArrayOf(0x1f32d), _HotDog)
    add(intArrayOf(0x1f96a), _Sandwich)
    add(intArrayOf(0x1f32e), _Taco)
    add(intArrayOf(0x1f32f), _Burrito)
    add(intArrayOf(0x1fad4), _Tamale)
    add(intArrayOf(0x1f959), _StuffedFlatbread)
    add(intArrayOf(0x1f9c6), _Falafel)
    add(intArrayOf(0x1f95a), _Egg)
    add(intArrayOf(0x1f373), _Cooking)
    add(intArrayOf(0x1f958), _ShallowPanOfFood)
    add(intArrayOf(0x1f372), _PotOfFood)
    add(intArrayOf(0x1fad5), _Fondue)
    add(intArrayOf(0x1f963), _BowlWithSpoon)
    add(intArrayOf(0x1f957), _GreenSalad)
    add(intArrayOf(0x1f37f), _Popcorn)
    add(intArrayOf(0x1f9c8), _Butter)
    add(intArrayOf(0x1f9c2), _Salt)
    add(intArrayOf(0x1f96b), _CannedFood)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFoodPrepared() {
    yield(_Bread)
    yield(_Croissant)
    yield(_BaguetteBread)
    yield(_Flatbread)
    yield(_Pretzel)
    yield(_Bagel)
    yield(_Pancakes)
    yield(_Waffle)
    yield(_CheeseWedge)
    yield(_MeatOnBone)
    yield(_PoultryLeg)
    yield(_CutOfMeat)
    yield(_Bacon)
    yield(_Hamburger)
    yield(_FrenchFries)
    yield(_Pizza)
    yield(_HotDog)
    yield(_Sandwich)
    yield(_Taco)
    yield(_Burrito)
    yield(_Tamale)
    yield(_StuffedFlatbread)
    yield(_Falafel)
    yield(_Egg)
    yield(_Cooking)
    yield(_ShallowPanOfFood)
    yield(_PotOfFood)
    yield(_Fondue)
    yield(_BowlWithSpoon)
    yield(_GreenSalad)
    yield(_Popcorn)
    yield(_Butter)
    yield(_Salt)
    yield(_CannedFood)
}

internal val countFoodPrepared = 34

/**
 * All Emoji of the Food & Drink: food-prepared subgroup.
*/
public fun Emoji.Companion.sequenceFoodPrepared(): Sequence<Emoji> =
    sequence { yieldAllFoodPrepared() }

/**
 * All Emoji of the Food & Drink: food-prepared subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFoodPrepared(): List<Emoji> =
    ArrayList<Emoji>(countFoodPrepared).also { list -> sequenceFoodPrepared().forEach { list.add(it) } }

@Deprecated("Renamed listFoodPrepared.", replaceWith = ReplaceWith("listFoodPrepared()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFoodPrepared(): List<Emoji> =
    listFoodPrepared()
