package org.kodein.emoji.food_drink.food_sweet

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ShavedIce: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍧",
        description = "shaved ice",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("shaved-ice", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: food-sweet: shaved ice.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ShavedIce: Emoji get() = _ShavedIce
