package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ChartIncreasing: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📈",
        description = "chart increasing",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("chart-increasing", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: office: chart increasing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ChartIncreasing: Emoji get() = _ChartIncreasing
