package org.kodein.emoji.people_body.hand_prop

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHandProp() {
    add(intArrayOf(0x270d, 0xfe0f), _WritingHand)
    add(intArrayOf(0x270d), _WritingHand)
    addVariations(intArrayOf(0x270d, 0x0), _WritingHand, 1)
    add(intArrayOf(0x1f485), _NailPolish)
    addVariations(intArrayOf(0x1f485, 0x0), _NailPolish, 1)
    add(intArrayOf(0x1f933), _Selfie)
    addVariations(intArrayOf(0x1f933, 0x0), _Selfie, 1)
}

internal suspend fun SequenceScope<Emoji>.yieldAllHandProp() {
    yield(_WritingHand)
    yield(_NailPolish)
    yield(_Selfie)
}

internal val countHandProp = 3

/**
 * All Emoji of the People & Body: hand-prop subgroup.
*/
public fun Emoji.Companion.sequenceHandProp(): Sequence<Emoji> =
    sequence { yieldAllHandProp() }

/**
 * All Emoji of the People & Body: hand-prop subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listHandProp(): List<Emoji> =
    ArrayList<Emoji>(countHandProp).also { list -> sequenceHandProp().forEach { list.add(it) } }

@Deprecated("Renamed listHandProp.", replaceWith = ReplaceWith("listHandProp()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allHandProp(): List<Emoji> =
    listHandProp()
