package org.kodein.emoji.people_body.person_gesture

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _DeafPerson: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧏",
        description = "deaf person",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("deaf-person", "deaf"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-gesture: deaf person.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DeafPerson: SkinTone1Emoji get() = _DeafPerson

/**
 * Alias to emoji [DeafPerson] (People & Body: person-gesture: deaf person).
*/
public val Emoji.Companion.Deaf: SkinTone1Emoji get() = _DeafPerson
