package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonSurfing: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🏄",
        description = "person surfing",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-surfing", "surfing"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-sport: person surfing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonSurfing: SkinTone1Emoji get() = _PersonSurfing

/**
 * Alias to emoji [PersonSurfing] (People & Body: person-sport: person surfing).
*/
public val Emoji.Companion.Surfing: SkinTone1Emoji get() = _PersonSurfing
