package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FrowningFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☹️",
        description = "frowning face",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("frowning-face", "big-frown"),
        emoticons = listOf(":-("),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: frowning face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FrowningFace: Emoji get() = _FrowningFace

/**
 * Alias to emoji [FrowningFace] (Smileys & Emotion: face-concerned: frowning face).
*/
public val Emoji.Companion.BigFrown: Emoji get() = _FrowningFace
