package org.kodein.emoji.smileys_emotion.face_tongue

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WinkingFaceWithTongue: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😜",
        description = "winking face with tongue",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("winking-face-with-tongue", "winky-tongue"),
        emoticons = listOf(";p"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-tongue: winking face with tongue.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WinkingFaceWithTongue: Emoji get() = _WinkingFaceWithTongue

/**
 * Alias to emoji [WinkingFaceWithTongue] (Smileys & Emotion: face-tongue: winking face with tongue).
*/
public val Emoji.Companion.WinkyTongue: Emoji get() = _WinkingFaceWithTongue
