package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BrightButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔆",
        description = "bright button",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("bright-button", "bright", "brightness"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: bright button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BrightButton: Emoji get() = _BrightButton

/**
 * Alias to emoji [BrightButton] (Symbols: av-symbol: bright button).
*/
public val Emoji.Companion.Bright: Emoji get() = _BrightButton

/**
 * Alias to emoji [BrightButton] (Symbols: av-symbol: bright button).
*/
public val Emoji.Companion.Brightness: Emoji get() = _BrightButton
