package org.kodein.emoji.symbols.gender

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MaleSign: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♂️",
        description = "male sign",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("male-sign", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: gender: male sign.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MaleSign: Emoji get() = _MaleSign
