/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.ajaxterm.trilead;

import com.trilead.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.kohsuke.ajaxterm.ProcessWithPty;

public class SshProcessWithPty
extends ProcessWithPty {
    private final Session ssh;

    public SshProcessWithPty(Session ssh) {
        this.ssh = ssh;
    }

    public void setWindowSize(int width, int height) throws IOException {
        this.ssh.requestWindowChange(width, height, 0, 0);
    }

    public OutputStream getOutputStream() {
        return this.ssh.getStdin();
    }

    public InputStream getErrorStream() {
        return this.ssh.getStderr();
    }

    public InputStream getInputStream() {
        return this.ssh.getStdout();
    }

    public void kill(int signal) throws IOException {
        this.ssh.signal(signal);
    }

    public int exitValue() {
        Integer v = this.ssh.getExitStatus();
        if (v == null) {
            throw new IllegalThreadStateException();
        }
        return v;
    }

    public boolean isAlive() {
        return this.ssh.getExitStatus() == null;
    }

    public int waitFor() throws InterruptedException {
        this.ssh.waitForCondition(32, 0L);
        return this.ssh.getExitStatus();
    }

    public void destroy() {
        try {
            this.kill(9);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

