/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.ajaxterm.demo;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.InteractiveCallback;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.ajaxterm.ProcessWithPty;
import org.kohsuke.ajaxterm.Session;
import org.kohsuke.ajaxterm.trilead.SshProcessWithPty;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.adjunct.AdjunctManager;

public class AjaxTerm {
    Session session;
    public final AdjunctManager adjuncts;

    public AjaxTerm(ServletContext context) {
        this.adjuncts = new AdjunctManager(context, this.getClass().getClassLoader(), "adjuncts");
    }

    public HttpResponse doIndex() {
        if (this.session != null) {
            return HttpResponses.forwardToView((Object)this, (String)"session.gsp");
        }
        return HttpResponses.forwardToView((Object)this, (String)"login.gsp");
    }

    public void doU(StaplerRequest req, StaplerResponse rsp) throws Exception {
        this.session.handleUpdate((HttpServletRequest)req, (HttpServletResponse)rsp);
    }

    public HttpResponse doLocal(@QueryParameter int w, @QueryParameter int h) throws Exception {
        this.doDestroy();
        this.session = new Session(w, h, Session.getAjaxTerm(), new String[]{"/bin/bash", "--login"});
        return HttpResponses.redirectToDot();
    }

    public HttpResponse doLogin(@QueryParameter String host, @QueryParameter int port, @QueryParameter String user, @QueryParameter String password, @QueryParameter int w, @QueryParameter int h) throws Exception {
        Connection con = new Connection(host, port);
        con.connect();
        if (!con.authenticateWithPassword(user, password)) {
            con.authenticateWithKeyboardInteractive(user, (InteractiveCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!con.isAuthenticationComplete()) {
            throw new IOException("Authentication failed");
        }
        com.trilead.ssh2.Session s = con.openSession();
        s.requestPTY(Session.getAjaxTerm(), w, h, 0, 0, null);
        s.startShell();
        this.doDestroy();
        this.session = new Session(w, h, (ProcessWithPty)new SshProcessWithPty(s));
        return HttpResponses.redirectToDot();
    }

    public HttpResponse doDestroy() {
        if (this.session != null) {
            this.session.getChildProcess().destroy();
        }
        this.session = null;
        return HttpResponses.redirectToDot();
    }
}

