/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.apt.ftparchive.merge;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.kohsuke.apt.ftparchive.merge.PackageDef;
import org.kohsuke.apt.ftparchive.merge.PackageList;

public class MergeMojo
extends AbstractMojo {
    private URL repository;
    private File output;

    public void execute() throws MojoExecutionException {
        try {
            String line;
            BufferedReader in;
            this.getLog().info((CharSequence)"Merging Packages");
            boolean skip = this.isEmpty(System.getenv("SKIP_APT_MERGE"));
            PackageList base = skip ? new PackageList() : this.loadPackages(new GZIPInputStream(new URL(this.repository, "Packages.gz").openStream()));
            PackageList updated = this.loadPackages(new FileInputStream(new File("Packages")));
            for (PackageDef p : updated) {
                PackageDef old = base.get(p.getName());
                if (old != null) {
                    base.remove(old);
                }
                base.add(p);
            }
            base.sort();
            this.output.mkdirs();
            FileOutputStream pw = new FileOutputStream(new File(this.output, "Packages"));
            base.write(pw);
            pw.close();
            this.getLog().info((CharSequence)"Merging Contents");
            Set<String> localPackageNames = updated.getPackageNames();
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.output, "Contents")), "UTF-8"));
            if (!skip) {
                in = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new URL(this.repository, "Contents.gz").openStream()), "UTF-8"));
                while ((line = in.readLine()) != null) {
                    int idx = Math.max(line.lastIndexOf(9), line.lastIndexOf(32));
                    String name = line.substring(idx + 1);
                    if (localPackageNames.contains(name)) continue;
                    out.println(line);
                }
                in.close();
            }
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("Contents"), "UTF-8"));
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Failed to merge", (Exception)e);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageList loadPackages(InputStream in) throws IOException {
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            PackageList packages = new PackageList();
            ArrayList<String> read = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                if (line.length() == 0) {
                    packages.add(new PackageDef(read));
                    read = new ArrayList();
                    continue;
                }
                read.add(line);
            }
            if (!read.isEmpty()) {
                packages.add(new PackageDef(read));
            }
            PackageList packageList = packages;
            return packageList;
        }
        finally {
            in.close();
        }
    }
}

