/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.apt.ftparchive.merge;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.apt.ftparchive.merge.PackageDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageList
extends ArrayList<PackageDef> {
    public PackageDef get(String name) {
        for (PackageDef p : this) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public void sort() {
        Collections.sort(this, new Comparator<PackageDef>(){

            @Override
            public int compare(PackageDef o1, PackageDef o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public void write(OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
        for (PackageDef p : this) {
            p.write(w);
        }
        w.flush();
    }

    public Set<String> getPackageNames() {
        HashSet<String> r = new HashSet<String>();
        for (PackageDef p : this) {
            r.add(p.getName());
        }
        return r;
    }
}

