/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.apt.ftparchive.merge;

import java.io.IOException;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageDef {
    private final List<String> lines;
    private static final String PACKAGE_HEADER = "Package: ";

    public PackageDef(List<String> lines) {
        if (lines.isEmpty()) {
            throw new AssertionError();
        }
        this.lines = lines;
    }

    public String getName() {
        for (String line : this.lines) {
            if (!line.startsWith(PACKAGE_HEADER)) continue;
            return line.substring(PACKAGE_HEADER.length());
        }
        throw new AssertionError((Object)("No package name found in " + this.lines));
    }

    public void write(Writer w) throws IOException {
        for (String line : this.lines) {
            w.write(line);
            w.write(10);
        }
        w.write(10);
    }
}

