/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.kohsuke.args4j.apt.Main;

public class Args4jUsageMojo
extends AbstractMojo {
    private String mode;
    private String sourceDir;
    protected String args4jBuildDirPath;
    private List<String> sourceFiles;
    private File jar;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.sourceFiles == null || this.sourceFiles.size() == 0) {
            this.getLog().info((CharSequence)"No sourceFiles defined. Skipping");
            return;
        }
        File args4jBuildDir = new File(this.args4jBuildDirPath);
        if (!args4jBuildDir.exists() && !args4jBuildDir.mkdirs()) {
            throw new MojoExecutionException("Couldn't create the directory " + args4jBuildDir.getAbsolutePath());
        }
        try {
            String path = Main.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String enc = System.getProperty("file.encoding");
            path = URLDecoder.decode(path, enc);
            this.jar = new File(path);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't find the jar of the arg4s tools");
        }
        this.getLog().debug((CharSequence)("Jar path:" + this.jar));
        for (String relativeSourceFilePath : this.sourceFiles) {
            try {
                File sourceFile = new File(this.sourceDir, relativeSourceFilePath);
                if (!sourceFile.exists()) {
                    this.getLog().warn((CharSequence)("Source file " + sourceFile.getAbsolutePath() + " not found. Skipping"));
                    continue;
                }
                this.getLog().debug((CharSequence)("Generating usage for " + sourceFile.getAbsolutePath()));
                this.generateUsage(sourceFile.getAbsolutePath(), args4jBuildDir);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to generate usage for " + relativeSourceFilePath, e);
            }
        }
    }

    private void generateUsage(String sourceFile, File args4jBuildDir) throws InterruptedException, IOException {
        String outputDir = args4jBuildDir.getAbsolutePath();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command("java", "-jar", this.jar.getAbsolutePath(), "-o", outputDir, "-mode", this.mode, sourceFile);
        this.printCommand(pb);
        Process process = pb.start();
        InputStreamReader isr = this.dumpOutput(process);
        int r = process.waitFor();
        isr.close();
        if (r != 0) {
            throw new IOException("args4j generation failed: " + r);
        }
    }

    private void printCommand(ProcessBuilder pb) {
        StringBuilder sb = new StringBuilder();
        sb.append("Running: ");
        for (String s : pb.command()) {
            sb.append(s).append(" ");
        }
        sb.append("from ").append(this.dir(pb).getAbsolutePath());
        this.getLog().debug((CharSequence)sb.toString());
    }

    private File dir(ProcessBuilder pb) {
        File directory = pb.directory();
        if (directory == null) {
            return new File(System.getProperty("user.dir"));
        }
        return directory;
    }

    private InputStreamReader dumpOutput(Process process) throws IOException {
        String line;
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        return isr;
    }
}

