/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.asm2.attrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.asm2.Attribute;
import org.kohsuke.asm2.ByteVector;
import org.kohsuke.asm2.ClassReader;
import org.kohsuke.asm2.ClassWriter;
import org.kohsuke.asm2.Label;
import org.kohsuke.asm2.Type;
import org.kohsuke.asm2.attrs.StackMapFrame;
import org.kohsuke.asm2.attrs.StackMapType;

public class StackMapTableAttribute
extends Attribute {
    public static final int SAME_FRAME = 0;
    public static final int SAME_LOCALS_1_STACK_ITEM_FRAME = 64;
    public static final int RESERVED = 128;
    public static final int SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED = 247;
    public static final int CHOP_FRAME = 248;
    public static final int SAME_FRAME_EXTENDED = 251;
    public static final int APPEND_FRAME = 252;
    public static final int FULL_FRAME = 255;
    private List frames;

    public StackMapTableAttribute() {
        super("StackMapTable");
    }

    public StackMapTableAttribute(List list) {
        this();
        this.frames = list;
    }

    public List getFrames() {
        return this.frames;
    }

    public StackMapFrame getFrame(Label label) {
        for (int i = 0; i < this.frames.size(); ++i) {
            StackMapFrame stackMapFrame = (StackMapFrame)this.frames.get(i);
            if (stackMapFrame.label != label) continue;
            return stackMapFrame;
        }
        return null;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isCodeAttribute() {
        return true;
    }

    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        int n4;
        ArrayList<StackMapFrame> arrayList = new ArrayList<StackMapFrame>();
        boolean bl = classReader.readInt(n3 + 4) > 65535;
        boolean bl2 = classReader.readUnsignedShort(n3 + 2) > 65535;
        boolean bl3 = classReader.readUnsignedShort(n3) > 65535;
        int n5 = 0;
        int n6 = StackMapTableAttribute.getMethodOff(classReader, n3, cArray);
        StackMapFrame stackMapFrame = new StackMapFrame(this.getLabel(n5, labelArray), StackMapTableAttribute.calculateLocals(classReader.readClass(classReader.header + 2, cArray), classReader.readUnsignedShort(n6), classReader.readUTF8(n6 + 2, cArray), classReader.readUTF8(n6 + 4, cArray)), Collections.EMPTY_LIST);
        arrayList.add(stackMapFrame);
        if (bl) {
            n4 = classReader.readInt(n);
            n += 4;
        } else {
            n4 = classReader.readUnsignedShort(n);
            n += 2;
        }
        while (n4 > 0) {
            List list;
            ArrayList arrayList2;
            int n7;
            int n8 = classReader.readByte(n);
            ++n;
            if (n8 < 64) {
                n7 = n8;
                arrayList2 = new ArrayList(stackMapFrame.locals);
                list = Collections.EMPTY_LIST;
            } else if (n8 < 128) {
                n7 = n8 - 64;
                arrayList2 = new ArrayList(stackMapFrame.locals);
                list = new ArrayList();
                n = this.readType(list, bl, classReader, n, labelArray, cArray);
            } else {
                if (bl) {
                    n7 = classReader.readInt(n);
                    n += 4;
                } else {
                    n7 = classReader.readUnsignedShort(n);
                    n += 2;
                }
                if (n8 == 247) {
                    arrayList2 = new ArrayList(stackMapFrame.locals);
                    list = new ArrayList();
                    n = this.readType(list, bl, classReader, n, labelArray, cArray);
                } else if (n8 >= 248 && n8 < 251) {
                    list = Collections.EMPTY_LIST;
                    int n9 = 251 - n8;
                    arrayList2 = new ArrayList(stackMapFrame.locals.subList(0, stackMapFrame.locals.size() - n9));
                } else if (n8 == 251) {
                    list = Collections.EMPTY_LIST;
                    arrayList2 = new ArrayList(stackMapFrame.locals);
                } else if (n8 < 255) {
                    list = Collections.EMPTY_LIST;
                    arrayList2 = new ArrayList(stackMapFrame.locals);
                    for (int i = n8 - 251; i > 0; --i) {
                        n = this.readType(arrayList2, bl, classReader, n, labelArray, cArray);
                    }
                } else if (n8 == 255) {
                    arrayList2 = new ArrayList();
                    n = this.readTypes(arrayList2, bl2, bl, classReader, n, labelArray, cArray);
                    list = new ArrayList();
                    n = this.readTypes(list, bl3, bl, classReader, n, labelArray, cArray);
                } else {
                    throw new RuntimeException("Unknown frame type " + n8 + " after offset " + n5);
                }
            }
            Label label = this.getLabel(n5 += n7, labelArray);
            stackMapFrame = new StackMapFrame(label, arrayList2, list);
            arrayList.add(stackMapFrame);
            ++n5;
            --n4;
        }
        return new StackMapTableAttribute(arrayList);
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        ByteVector byteVector = new ByteVector();
        boolean bl = byArray != null && byArray.length > 65535;
        this.writeSize(this.frames.size() - 1, byteVector, bl);
        if (this.frames.size() < 2) {
            return byteVector;
        }
        boolean bl2 = n3 > 65535;
        boolean bl3 = n2 > 65535;
        StackMapFrame stackMapFrame = (StackMapFrame)this.frames.get(0);
        List list = stackMapFrame.locals;
        int n4 = stackMapFrame.label.getOffset();
        for (int i = 1; i < this.frames.size(); ++i) {
            stackMapFrame = (StackMapFrame)this.frames.get(i);
            List list2 = stackMapFrame.locals;
            List list3 = stackMapFrame.stack;
            int n5 = stackMapFrame.label.getOffset();
            int n6 = list2.size();
            int n7 = list3.size();
            int n8 = list.size();
            int n9 = n5 - n4;
            int n10 = 255;
            int n11 = 0;
            if (n7 == 0) {
                n11 = n6 - n8;
                switch (n11) {
                    case -3: 
                    case -2: 
                    case -1: {
                        n10 = 248;
                        n8 = n6;
                        break;
                    }
                    case 0: {
                        n10 = n9 < 64 ? 0 : 251;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n10 = 252;
                    }
                }
            } else if (n8 == n6 && n7 == 1) {
                int n12 = n10 = n9 < 63 ? 64 : 247;
            }
            if (n10 != 255) {
                for (int j = 0; j < n8 && n10 != 255; ++j) {
                    if (list.get(j).equals(list2.get(j))) continue;
                    n10 = 255;
                }
            }
            switch (n10) {
                case 0: {
                    byteVector.putByte(n9);
                    break;
                }
                case 64: {
                    byteVector.putByte(64 + n9);
                    this.writeTypeInfos(byteVector, classWriter, list3, 0, 1);
                    break;
                }
                case 247: {
                    byteVector.putByte(247);
                    this.writeSize(n9, byteVector, bl);
                    this.writeTypeInfos(byteVector, classWriter, list3, 0, 1);
                    break;
                }
                case 251: {
                    byteVector.putByte(251);
                    this.writeSize(n9, byteVector, bl);
                    break;
                }
                case 248: {
                    byteVector.putByte(251 + n11);
                    this.writeSize(n9, byteVector, bl);
                    break;
                }
                case 252: {
                    byteVector.putByte(251 + n11);
                    this.writeSize(n9, byteVector, bl);
                    this.writeTypeInfos(byteVector, classWriter, list2, n6 - 1, n6);
                    break;
                }
                case 255: {
                    byteVector.putByte(255);
                    this.writeSize(n9, byteVector, bl);
                    this.writeSize(n6, byteVector, bl2);
                    this.writeTypeInfos(byteVector, classWriter, list2, 0, n6);
                    this.writeSize(n7, byteVector, bl3);
                    this.writeTypeInfos(byteVector, classWriter, list3, 0, n7);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            n4 = n5 + 1;
            list = list2;
        }
        return byteVector;
    }

    private void writeSize(int n, ByteVector byteVector, boolean bl) {
        if (bl) {
            byteVector.putInt(n);
        } else {
            byteVector.putShort(n);
        }
    }

    private void writeTypeInfos(ByteVector byteVector, ClassWriter classWriter, List list, int n, int n2) {
        block4: for (int i = n; i < n2; ++i) {
            StackMapType stackMapType = (StackMapType)list.get(i);
            byteVector.putByte(stackMapType.getType());
            switch (stackMapType.getType()) {
                case 7: {
                    byteVector.putShort(classWriter.newClass(stackMapType.getObject()));
                    continue block4;
                }
                case 8: {
                    byteVector.putShort(stackMapType.getLabel().getOffset());
                }
            }
        }
    }

    public static int getMethodOff(ClassReader classReader, int n, char[] cArray) {
        int n2;
        int n3 = classReader.header + 6;
        int n4 = classReader.readUnsignedShort(n3);
        n3 += 2;
        for (int i = classReader.readUnsignedShort(n3 += 2 + n4 * 2); i > 0; --i) {
            n2 = classReader.readUnsignedShort(n3 + 6);
            n3 += 8;
            while (n2 > 0) {
                n3 += 6 + classReader.readInt(n3 + 2);
                --n2;
            }
        }
        n2 = classReader.readUnsignedShort(n3);
        n3 += 2;
        while (n2 > 0) {
            int n5 = n3;
            int n6 = classReader.readUnsignedShort(n3 + 6);
            n3 += 8;
            while (n6 > 0) {
                String string = classReader.readUTF8(n3, cArray);
                if (string.equals("Code") && n == (n3 += 6)) {
                    return n5;
                }
                n3 += classReader.readInt(n3 - 4);
                --n6;
            }
            --n2;
        }
        return -1;
    }

    public static List calculateLocals(String string, int n, String string2, String string3) {
        Type[] typeArray;
        ArrayList<Type[]> arrayList = new ArrayList<Type[]>();
        if ("<init>".equals(string2) && !string.equals("java/lang/Object")) {
            typeArray = StackMapType.getTypeInfo(6);
            typeArray.setObject(string);
            arrayList.add(typeArray);
        } else if ((n & 8) == 0) {
            typeArray = StackMapType.getTypeInfo(7);
            typeArray.setObject(string);
            arrayList.add(typeArray);
        }
        typeArray = Type.getArgumentTypes(string3);
        block6: for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            switch (type.getSort()) {
                case 7: {
                    StackMapType stackMapType = StackMapType.getTypeInfo(4);
                    continue block6;
                }
                case 8: {
                    StackMapType stackMapType = StackMapType.getTypeInfo(3);
                    continue block6;
                }
                case 6: {
                    StackMapType stackMapType = StackMapType.getTypeInfo(2);
                    continue block6;
                }
                case 9: 
                case 10: {
                    StackMapType stackMapType = StackMapType.getTypeInfo(7);
                    stackMapType.setObject(type.getDescriptor());
                    continue block6;
                }
                default: {
                    StackMapType stackMapType = StackMapType.getTypeInfo(1);
                }
            }
        }
        return arrayList;
    }

    private int readTypes(List list, boolean bl, boolean bl2, ClassReader classReader, int n, Label[] labelArray, char[] cArray) {
        int n2 = 0;
        if (bl) {
            n2 = classReader.readInt(n);
            n += 4;
        } else {
            n2 = classReader.readUnsignedShort(n);
            n += 2;
        }
        while (n2 > 0) {
            n = this.readType(list, bl2, classReader, n, labelArray, cArray);
            --n2;
        }
        return n;
    }

    private int readType(List list, boolean bl, ClassReader classReader, int n, Label[] labelArray, char[] cArray) {
        int n2 = classReader.readByte(n++);
        StackMapType stackMapType = StackMapType.getTypeInfo(n2);
        list.add(stackMapType);
        switch (n2) {
            case 7: {
                stackMapType.setObject(classReader.readClass(n, cArray));
                n += 2;
                break;
            }
            case 8: {
                int n3;
                if (bl) {
                    n3 = classReader.readInt(n);
                    n += 4;
                } else {
                    n3 = classReader.readUnsignedShort(n);
                    n += 2;
                }
                stackMapType.setLabel(this.getLabel(n3, labelArray));
            }
        }
        return n;
    }

    private Label getLabel(int n, Label[] labelArray) {
        Label label = labelArray[n];
        if (label != null) {
            return label;
        }
        labelArray[n] = new Label();
        return labelArray[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StackMapTable[");
        for (int i = 0; i < this.frames.size(); ++i) {
            stringBuffer.append('\n').append('[').append(this.frames.get(i)).append(']');
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

