/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.asm2.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.kohsuke.asm2.Label;
import org.kohsuke.asm2.Opcodes;
import org.kohsuke.asm2.Type;
import org.kohsuke.asm2.tree.AbstractInsnNode;
import org.kohsuke.asm2.tree.IincInsnNode;
import org.kohsuke.asm2.tree.JumpInsnNode;
import org.kohsuke.asm2.tree.LabelNode;
import org.kohsuke.asm2.tree.LookupSwitchInsnNode;
import org.kohsuke.asm2.tree.MethodNode;
import org.kohsuke.asm2.tree.TableSwitchInsnNode;
import org.kohsuke.asm2.tree.TryCatchBlockNode;
import org.kohsuke.asm2.tree.VarInsnNode;
import org.kohsuke.asm2.tree.analysis.AnalyzerException;
import org.kohsuke.asm2.tree.analysis.Frame;
import org.kohsuke.asm2.tree.analysis.IntMap;
import org.kohsuke.asm2.tree.analysis.Interpreter;
import org.kohsuke.asm2.tree.analysis.Subroutine;

public class Analyzer
implements Opcodes {
    private Interpreter interpreter;
    private int n;
    private IntMap indexes;
    private List[] handlers;
    private Frame[] frames;
    private Subroutine[] subroutines;
    private boolean[] queued;
    private int[] queue;
    private int top;
    private boolean jsr;

    public Analyzer(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Frame[] analyze(String string, MethodNode methodNode) throws AnalyzerException {
        int n;
        ArrayList<Object> arrayList;
        int n2;
        Object object;
        int n3;
        this.n = methodNode.instructions.size();
        this.indexes = new IntMap(2 * this.n);
        this.handlers = new List[this.n];
        this.frames = new Frame[this.n];
        this.subroutines = new Subroutine[this.n];
        this.queued = new boolean[this.n];
        this.queue = new int[this.n];
        this.top = 0;
        for (n3 = 0; n3 < this.n; ++n3) {
            object = methodNode.instructions.get(n3);
            if (object instanceof LabelNode) {
                object = ((LabelNode)object).label;
            }
            this.indexes.put(object, n3);
        }
        for (n3 = 0; n3 < methodNode.tryCatchBlocks.size(); ++n3) {
            object = (TryCatchBlockNode)methodNode.tryCatchBlocks.get(n3);
            int n4 = this.indexes.get(((TryCatchBlockNode)object).start);
            n2 = this.indexes.get(((TryCatchBlockNode)object).end);
            for (int i = n4; i < n2; ++i) {
                arrayList = this.handlers[i];
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    this.handlers[i] = arrayList;
                }
                arrayList.add(object);
            }
        }
        Frame frame = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        object = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        Type[] typeArray = Type.getArgumentTypes(methodNode.desc);
        n2 = 0;
        if ((methodNode.access & 8) == 0) {
            Type type = Type.getType("L" + string + ";");
            frame.setLocal(n2++, this.interpreter.newValue(type));
        }
        for (n = 0; n < typeArray.length; ++n) {
            frame.setLocal(n2++, this.interpreter.newValue(typeArray[n]));
            if (typeArray[n].getSize() != 2) continue;
            frame.setLocal(n2++, this.interpreter.newValue(null));
        }
        while (n2 < methodNode.maxLocals) {
            frame.setLocal(n2++, this.interpreter.newValue(null));
        }
        this.merge(0, frame, null);
        while (this.top > 0) {
            n = this.queue[--this.top];
            arrayList = this.frames[n];
            Subroutine subroutine = this.subroutines[n];
            this.queued[n] = false;
            try {
                int n5;
                Object object2;
                Object e = methodNode.instructions.get(n);
                this.jsr = false;
                if (e instanceof LabelNode) {
                    this.merge(n + 1, (Frame)((Object)arrayList), subroutine);
                } else {
                    Label label;
                    int n6;
                    object2 = (AbstractInsnNode)e;
                    n5 = ((AbstractInsnNode)object2).getOpcode();
                    frame.init((Frame)((Object)arrayList)).execute((AbstractInsnNode)object2, this.interpreter);
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : subroutine.copy();
                    if (object2 instanceof JumpInsnNode) {
                        JumpInsnNode jumpInsnNode = (JumpInsnNode)object2;
                        if (n5 != 167 && n5 != 168) {
                            this.merge(n + 1, frame, subroutine);
                        }
                        if (n5 == 168) {
                            this.jsr = true;
                            this.merge(this.indexes.get(jumpInsnNode.label), frame, new Subroutine(jumpInsnNode.label, methodNode.maxLocals, jumpInsnNode));
                        } else {
                            this.merge(this.indexes.get(jumpInsnNode.label), frame, subroutine);
                        }
                    } else if (object2 instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lookupSwitchInsnNode = (LookupSwitchInsnNode)object2;
                        this.merge(this.indexes.get(lookupSwitchInsnNode.dflt), frame, subroutine);
                        for (n6 = 0; n6 < lookupSwitchInsnNode.labels.size(); ++n6) {
                            label = (Label)lookupSwitchInsnNode.labels.get(n6);
                            this.merge(this.indexes.get(label), frame, subroutine);
                        }
                    } else if (object2 instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tableSwitchInsnNode = (TableSwitchInsnNode)object2;
                        this.merge(this.indexes.get(tableSwitchInsnNode.dflt), frame, subroutine);
                        for (n6 = 0; n6 < tableSwitchInsnNode.labels.size(); ++n6) {
                            label = (Label)tableSwitchInsnNode.labels.get(n6);
                            this.merge(this.indexes.get(label), frame, subroutine);
                        }
                    } else if (n5 == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException("RET instruction outside of a sub routine");
                        }
                        for (int i = 0; i < subroutine.callers.size(); ++i) {
                            n6 = this.indexes.get(subroutine.callers.get(i));
                            this.merge(n6 + 1, this.frames[n6], frame, this.subroutines[n6], subroutine.access);
                        }
                    } else if (n5 != 191 && (n5 < 172 || n5 > 177)) {
                        if (subroutine != null) {
                            if (object2 instanceof VarInsnNode) {
                                int n7 = ((VarInsnNode)object2).var;
                                subroutine.access[n7] = true;
                                if (n5 == 22 || n5 == 24 || n5 == 55 || n5 == 57) {
                                    subroutine.access[n7 + 1] = true;
                                }
                            } else if (object2 instanceof IincInsnNode) {
                                int n8 = ((IincInsnNode)object2).var;
                                subroutine.access[n8] = true;
                            }
                        }
                        this.merge(n + 1, frame, subroutine);
                    }
                }
                if ((object2 = this.handlers[n]) == null) continue;
                for (n5 = 0; n5 < object2.size(); ++n5) {
                    TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)object2.get(n5);
                    Type type = tryCatchBlockNode.type == null ? Type.getType("Ljava/lang/Throwable;") : Type.getType("L" + tryCatchBlockNode.type + ";");
                    ((Frame)object).init((Frame)((Object)arrayList));
                    ((Frame)object).clearStack();
                    ((Frame)object).push(this.interpreter.newValue(type));
                    this.merge(this.indexes.get(tryCatchBlockNode.handler), (Frame)object, subroutine);
                }
            }
            catch (AnalyzerException analyzerException) {
                throw new AnalyzerException("Error at instruction " + n + ": " + analyzerException.getMessage(), analyzerException);
            }
            catch (Exception exception) {
                throw new AnalyzerException("Error at instruction " + n + ": " + exception.getMessage(), exception);
            }
        }
        return this.frames;
    }

    public Frame[] getFrames() {
        return this.frames;
    }

    public int getIndex(Object object) {
        return this.indexes.get(object);
    }

    public List getHandlers(int n) {
        return this.handlers[n];
    }

    protected Frame newFrame(int n, int n2) {
        return new Frame(n, n2);
    }

    protected Frame newFrame(Frame frame) {
        return new Frame(frame);
    }

    protected void newControlFlowEdge(Frame frame, Frame frame2) {
    }

    private void merge(int n, Frame frame, Subroutine subroutine) throws AnalyzerException {
        if (n > this.n - 1) {
            throw new AnalyzerException("Execution can fall off end of the code");
        }
        Frame frame2 = this.frames[n];
        Subroutine subroutine2 = this.subroutines[n];
        boolean bl = false;
        if (frame2 == null) {
            this.frames[n] = this.newFrame(frame);
            bl = true;
        } else {
            bl |= frame2.merge(frame, this.interpreter);
        }
        this.newControlFlowEdge(frame, frame2);
        if (subroutine2 == null) {
            if (subroutine != null) {
                this.subroutines[n] = subroutine.copy();
                bl = true;
            }
        } else if (subroutine != null) {
            bl |= subroutine2.merge(subroutine, !this.jsr);
        }
        if (bl && !this.queued[n]) {
            this.queued[n] = true;
            this.queue[this.top++] = n;
        }
    }

    private void merge(int n, Frame frame, Frame frame2, Subroutine subroutine, boolean[] blArray) throws AnalyzerException {
        if (n > this.n - 1) {
            throw new AnalyzerException("Execution can fall off end of the code");
        }
        Frame frame3 = this.frames[n];
        Subroutine subroutine2 = this.subroutines[n];
        boolean bl = false;
        frame2.merge(frame, blArray);
        if (frame3 == null) {
            this.frames[n] = this.newFrame(frame2);
            bl = true;
        } else {
            bl |= frame3.merge(frame2, blArray);
        }
        this.newControlFlowEdge(frame2, frame3);
        if (subroutine2 == null) {
            if (subroutine != null) {
                this.subroutines[n] = subroutine.copy();
                bl = true;
            }
        } else if (subroutine != null) {
            bl |= subroutine2.merge(subroutine, !this.jsr);
        }
        if (bl && !this.queued[n]) {
            this.queued[n] = true;
            this.queue[this.top++] = n;
        }
    }
}

