/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.asm2.util;

import java.util.HashMap;
import org.kohsuke.asm2.AnnotationVisitor;
import org.kohsuke.asm2.Label;
import org.kohsuke.asm2.MethodVisitor;
import org.kohsuke.asm2.util.ASMifierAbstractVisitor;
import org.kohsuke.asm2.util.ASMifierAnnotationVisitor;

public class ASMifierMethodVisitor
extends ASMifierAbstractVisitor
implements MethodVisitor {
    public ASMifierMethodVisitor() {
        super("mv");
        this.labelNames = new HashMap();
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.buf.setLength(0);
        this.buf.append("{\n").append("av0 = mv.visitAnnotationDefault();\n");
        this.text.add(this.buf.toString());
        ASMifierAnnotationVisitor aSMifierAnnotationVisitor = new ASMifierAnnotationVisitor(0);
        this.text.add(aSMifierAnnotationVisitor.getText());
        this.text.add("}\n");
        return aSMifierAnnotationVisitor;
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        this.buf.setLength(0);
        this.buf.append("{\n").append("av0 = mv.visitParameterAnnotation(").append(n).append(", ");
        this.appendConstant(string);
        this.buf.append(", ").append(bl).append(");\n");
        this.text.add(this.buf.toString());
        ASMifierAnnotationVisitor aSMifierAnnotationVisitor = new ASMifierAnnotationVisitor(0);
        this.text.add(aSMifierAnnotationVisitor.getText());
        this.text.add("}\n");
        return aSMifierAnnotationVisitor;
    }

    public void visitCode() {
        this.text.add("mv.visitCode();\n");
    }

    public void visitInsn(int n) {
        this.buf.setLength(0);
        this.buf.append("mv.visitInsn(").append(OPCODES[n]).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitIntInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitIntInsn(").append(OPCODES[n]).append(", ").append(n == 188 ? TYPES[n2] : Integer.toString(n2)).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitVarInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitVarInsn(").append(OPCODES[n]).append(", ").append(n2).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitTypeInsn(int n, String string) {
        this.buf.setLength(0);
        this.buf.append("mv.visitTypeInsn(").append(OPCODES[n]).append(", ");
        this.appendConstant(string);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append("mv.visitFieldInsn(").append(OPCODES[n]).append(", ");
        this.appendConstant(string);
        this.buf.append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append("mv.visitMethodInsn(").append(OPCODES[n]).append(", ");
        this.appendConstant(string);
        this.buf.append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitJumpInsn(int n, Label label) {
        this.buf.setLength(0);
        this.declareLabel(label);
        this.buf.append("mv.visitJumpInsn(").append(OPCODES[n]).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.declareLabel(label);
        this.buf.append("mv.visitLabel(");
        this.appendLabel(label);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLdcInsn(Object object) {
        this.buf.setLength(0);
        this.buf.append("mv.visitLdcInsn(");
        this.appendConstant(object);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitIincInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitIincInsn(").append(n).append(", ").append(n2).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        int n3;
        this.buf.setLength(0);
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.declareLabel(labelArray[n3]);
        }
        this.declareLabel(label);
        this.buf.append("mv.visitTableSwitchInsn(").append(n).append(", ").append(n2).append(", ");
        this.appendLabel(label);
        this.buf.append(", new Label[] {");
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.buf.append(n3 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n3]);
        }
        this.buf.append(" });\n");
        this.text.add(this.buf.toString());
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n;
        this.buf.setLength(0);
        for (n = 0; n < labelArray.length; ++n) {
            this.declareLabel(labelArray[n]);
        }
        this.declareLabel(label);
        this.buf.append("mv.visitLookupSwitchInsn(");
        this.appendLabel(label);
        this.buf.append(", new int[] {");
        for (n = 0; n < nArray.length; ++n) {
            this.buf.append(n == 0 ? " " : ", ").append(nArray[n]);
        }
        this.buf.append(" }, new Label[] {");
        for (n = 0; n < labelArray.length; ++n) {
            this.buf.append(n == 0 ? " " : ", ");
            this.appendLabel(labelArray[n]);
        }
        this.buf.append(" });\n");
        this.text.add(this.buf.toString());
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.buf.setLength(0);
        this.buf.append("mv.visitMultiANewArrayInsn(");
        this.appendConstant(string);
        this.buf.append(", ").append(n).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.buf.setLength(0);
        this.declareLabel(label);
        this.declareLabel(label2);
        this.declareLabel(label3);
        this.buf.append("mv.visitTryCatchBlock(");
        this.appendLabel(label);
        this.buf.append(", ");
        this.appendLabel(label2);
        this.buf.append(", ");
        this.appendLabel(label3);
        this.buf.append(", ");
        this.appendConstant(string);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.buf.setLength(0);
        this.buf.append("mv.visitLocalVariable(");
        this.appendConstant(string);
        this.buf.append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(", ");
        this.appendLabel(label);
        this.buf.append(", ");
        this.appendLabel(label2);
        this.buf.append(", ").append(n).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLineNumber(int n, Label label) {
        this.buf.setLength(0);
        this.buf.append("mv.visitLineNumber(").append(n).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitMaxs(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitMaxs(").append(n).append(", ").append(n2).append(");\n");
        this.text.add(this.buf.toString());
    }

    private void declareLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = "l" + this.labelNames.size();
            this.labelNames.put(label, string);
            this.buf.append("Label ").append(string).append(" = new Label();\n");
        }
    }

    private void appendLabel(Label label) {
        this.buf.append((String)this.labelNames.get(label));
    }
}

