/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.asm2.util;

import org.kohsuke.asm2.AnnotationVisitor;
import org.kohsuke.asm2.Attribute;
import org.kohsuke.asm2.util.AbstractVisitor;
import org.kohsuke.asm2.util.TraceAnnotationVisitor;
import org.kohsuke.asm2.util.attrs.Traceable;

public abstract class TraceAbstractVisitor
extends AbstractVisitor {
    public static final int INTERNAL_NAME = 0;
    public static final int FIELD_DESCRIPTOR = 1;
    public static final int FIELD_SIGNATURE = 2;
    public static final int METHOD_DESCRIPTOR = 3;
    public static final int METHOD_SIGNATURE = 4;
    public static final int CLASS_SIGNATURE = 5;
    public static final int TYPE_DECLARATION = 6;
    public static final int CLASS_DECLARATION = 7;
    public static final int PARAMETERS_DECLARATION = 8;
    protected String tab = "  ";

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append('@');
        this.appendDescriptor(1, string);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add(bl ? ")\n" : ") // invisible\n");
        return traceAnnotationVisitor;
    }

    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof Traceable) {
            ((Traceable)((Object)attribute)).trace(this.buf, null);
        } else {
            this.buf.append(" : ").append(attribute.toString()).append("\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitEnd() {
    }

    protected TraceAnnotationVisitor createTraceAnnotationVisitor() {
        return new TraceAnnotationVisitor();
    }

    protected void appendDescriptor(int n, String string) {
        if (n == 5 || n == 2 || n == 4) {
            if (string != null) {
                this.buf.append("// signature ").append(string).append('\n');
            }
        } else {
            this.buf.append(string);
        }
    }
}

