/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.eiie_logger.args4j.spi;

import java.util.ResourceBundle;
import org.kohsuke.eiie_logger.args4j.CmdLineException;
import org.kohsuke.eiie_logger.args4j.CmdLineParser;
import org.kohsuke.eiie_logger.args4j.OptionDef;
import org.kohsuke.eiie_logger.args4j.spi.Parameters;
import org.kohsuke.eiie_logger.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionHandler<T> {
    public final OptionDef option;
    public final Setter<? super T> setter;
    public final CmdLineParser owner;

    protected OptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter) {
        this.owner = parser;
        this.option = option;
        this.setter = setter;
    }

    public abstract int parseArguments(Parameters var1) throws CmdLineException;

    public abstract String getDefaultMetaVariable();

    public final String getMetaVariable(ResourceBundle rb) {
        String localized;
        String token = this.option.metaVar();
        if (token.length() == 0) {
            token = this.getDefaultMetaVariable();
        }
        if (token == null) {
            return null;
        }
        if (rb != null && (localized = rb.getString(token)) != null) {
            token = localized;
        }
        return token;
    }

    public final String getNameAndMeta(ResourceBundle rb) {
        String str = this.option.isArgument() ? "" : this.option.toString();
        String meta = this.getMetaVariable(rb);
        if (meta != null) {
            if (str.length() > 0) {
                str = str + " ";
            }
            str = str + meta;
        }
        return str;
    }
}

