/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.eiie_logger.transform;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.asm5.ClassReader;
import org.kohsuke.asm5.ClassVisitor;
import org.kohsuke.asm5.ClassWriter;
import org.kohsuke.asm5.MethodVisitor;
import org.kohsuke.eiie_logger.transform.ClassTransformSpec;
import org.kohsuke.eiie_logger.transform.MethodTransformSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerImpl
implements ClassFileTransformer {
    private final Map<String, ClassTransformSpec> specs = new HashMap<String, ClassTransformSpec>();

    public TransformerImpl(Collection<ClassTransformSpec> specs) {
        for (ClassTransformSpec spec : specs) {
            this.specs.put(spec.name, spec);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        return this.transform(className, classfileBuffer);
    }

    public byte[] transform(String className, byte[] classfileBuffer) {
        final ClassTransformSpec cs = this.specs.get(className);
        if (cs == null) {
            return classfileBuffer;
        }
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(1);
        cr.accept(new ClassVisitor(327680, (ClassVisitor)cw){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor base = super.visitMethod(access, name, desc, signature, exceptions);
                MethodTransformSpec ms = cs.methodSpecs.get(name + desc);
                if (ms == null) {
                    ms = cs.methodSpecs.get(name + "*");
                }
                if (ms == null) {
                    return base;
                }
                return ms.newAdapter(base, access, name, desc, signature, exceptions);
            }
        }, 4);
        return cw.toByteArray();
    }
}

