/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.file_leak_detecter;

import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Listener {
    private static final Map<Object, Record> TABLE = new HashMap<Object, Record>();
    public static PrintStream TRACE = null;
    public static PrintStream ERROR = System.err;
    private static boolean tracing = false;

    public static synchronized void open(Object _this, File f) {
        Record r = new Record(f);
        TABLE.put(_this, r);
        if (TRACE != null && !tracing) {
            tracing = true;
            r.dump("Opened ", TRACE);
            tracing = false;
        }
    }

    public static synchronized void close(Object _this) {
        Record r = TABLE.remove(_this);
        if (r != null && TRACE != null && !tracing) {
            tracing = true;
            r.dump("Closed ", TRACE);
            tracing = false;
        }
    }

    public static synchronized void dump(PrintStream ps) {
        ps.println(TABLE.size() + " files are open");
        for (Record r : TABLE.values()) {
            r.dump("", ps);
        }
    }

    public static synchronized void outOfDescriptors() {
        if (ERROR != null && !tracing) {
            tracing = true;
            ERROR.println("Too many open files");
            Listener.dump(ERROR);
            tracing = false;
        }
    }

    private static final class Record {
        public final File file;
        public final Exception stackTrace = new Exception();
        public final String threadName;
        public final long time;

        private Record(File file) {
            this.file = file;
            this.threadName = Thread.currentThread().getName();
            this.time = System.currentTimeMillis();
        }

        public void dump(String prefix, PrintStream ps) {
            int i;
            ps.println(prefix + this.file + " by thread:" + this.threadName + " on " + new Date(this.time));
            StackTraceElement[] trace = this.stackTrace.getStackTrace();
            for (i = 0; i < trace.length; ++i) {
                if (!trace[i].getClassName().equals("java.lang.reflect.Method")) continue;
                ++i;
                break;
            }
            while (i < trace.length) {
                ps.println("\tat " + trace[i]);
                ++i;
            }
        }
    }
}

