/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.file_leak_detector;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.file_leak_detector.AgentMain;

public class Main {
    @Argument(index=0, metaVar="PID", usage="Process ID to activate file leak detector", required=true)
    public String pid;
    @Argument(index=1, metaVar="OPTSTR", usage="Packed option string of the form key1[=value1],key2[=value2],...")
    public String options;
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        CmdLineParser p = new CmdLineParser((Object)main);
        try {
            p.parseArgument(args);
            main.run();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar file-leak-detector.jar PID [OPTSTR]");
            p.printUsage((OutputStream)System.err);
            System.err.println("\nOptions:");
            AgentMain.printOptions();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Class api = this.loadAttachApi();
        System.out.println("Connecting to " + this.pid);
        Object vm = api.getMethod("attach", String.class).invoke(null, this.pid);
        try {
            File agentJar = this.whichJar(this.getClass());
            System.out.println("Activating file leak detector at " + agentJar);
            api.getMethod("loadAgent", String.class, String.class).invoke(vm, agentJar.getPath(), this.options);
        }
        finally {
            api.getMethod("detach", new Class[0]).invoke(vm, new Object[0]);
        }
    }

    private Class loadAttachApi() throws MalformedURLException, ClassNotFoundException {
        File toolsJar = this.locateToolsJar();
        ClassLoader cl = this.wrapIntoClassLoader(toolsJar);
        try {
            return cl.loadClass("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to find tools.jar at " + toolsJar + " --- you need to run this tool with a JDK", e);
        }
    }

    protected ClassLoader wrapIntoClassLoader(File toolsJar) throws MalformedURLException {
        URL jar = toolsJar.toURI().toURL();
        ClassLoader base = this.getClass().getClassLoader();
        if (base instanceof URLClassLoader) {
            try {
                Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                addURL.invoke((Object)base, jar);
                return base;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load tools.jar into appclassloader", e);
            }
        }
        return new URLClassLoader(new URL[]{jar}, base);
    }

    private File locateToolsJar() {
        File home = new File(System.getProperty("java.home"));
        return new File(home, "../lib/tools.jar");
    }

    private File whichJar(Class c) {
        String url = c.getClassLoader().getResource(c.getName().replace('.', '/') + ".class").toExternalForm();
        if (url.startsWith("jar:file:")) {
            url = url.substring(0, url.lastIndexOf(33));
            url = url.substring(9);
            return new File(url);
        }
        throw new IllegalStateException("Unable to figure out the file of the jar: " + url);
    }
}

