/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.Refreshable;
import org.kohsuke.github.Requester;

@BridgeMethodsAdded
public class GHExternalGroup
extends GitHubInteractiveObject
implements Refreshable {
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
    private long groupId;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
    private String groupName;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
    private String updatedAt;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
    private List<GHLinkedTeam> teams = Collections.emptyList();
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
    private List<GHLinkedExternalMember> members = Collections.emptyList();
    private GHOrganization organization;

    GHExternalGroup() {
    }

    GHExternalGroup wrapUp(GHOrganization owner) {
        this.organization = owner;
        return this;
    }

    void wrapUp(GitHub root) {
        this.wrapUp(this.organization);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHOrganization getOrganization() {
        return this.organization;
    }

    public long getId() {
        return this.groupId;
    }

    public String getName() {
        return this.groupName;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getUpdatedAt() {
        return GitHubClient.parseInstant(this.updatedAt);
    }

    public List<GHLinkedTeam> getTeams() {
        return Collections.unmodifiableList(this.teams);
    }

    public List<GHLinkedExternalMember> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    @Override
    public void refresh() throws IOException {
        ((Requester)this.root().createRequest().withUrlPath(this.api(""), new String[0])).fetchInto(this).wrapUp(this.root());
    }

    private String api(String tail) {
        return "/orgs/" + this.organization.getLogin() + "/external-group/" + this.getId() + tail;
    }

    public static class GHLinkedExternalMember {
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
        private long memberId;
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
        private String memberLogin;
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
        private String memberName;
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
        private String memberEmail;

        public long getId() {
            return this.memberId;
        }

        public String getLogin() {
            return this.memberLogin;
        }

        public String getName() {
            return this.memberName;
        }

        public String getEmail() {
            return this.memberEmail;
        }
    }

    public static class GHLinkedTeam {
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
        private long teamId;
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
        private String teamName;

        public long getId() {
            return this.teamId;
        }

        public String getName() {
            return this.teamName;
        }
    }
}

