/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

@BridgeMethodsAdded
public abstract class GHPerson
extends GHObject {
    protected String login;
    protected String avatar_url;
    protected String location;
    protected String blog;
    protected String email;
    protected String bio;
    protected String name;
    protected String company;
    protected String type;
    protected String twitter_username;
    protected String html_url;
    protected int followers;
    protected int following;
    protected int public_repos;
    protected int public_gists;
    protected boolean site_admin;
    protected boolean hireable;
    protected Integer total_private_repos;

    protected synchronized void populate() throws IOException {
        if (super.getCreatedAt() != null) {
            return;
        }
        if (this.isOffline()) {
            return;
        }
        URL url = this.getUrl();
        if (url != null) {
            ((Requester)this.root().createRequest().setRawUrlPath(url.toString())).fetchInto(this);
        }
    }

    public synchronized Map<String, GHRepository> getRepositories() {
        TreeMap<String, GHRepository> repositories = new TreeMap<String, GHRepository>();
        for (GHRepository r : this.listRepositories().withPageSize(100)) {
            repositories.put(r.getName(), r);
        }
        return Collections.unmodifiableMap(repositories);
    }

    public PagedIterable<GHRepository> listRepositories() {
        return ((Requester)this.root().createRequest().withUrlPath("/users/" + this.login + "/repos", new String[0])).toIterable(GHRepository[].class, null).withPageSize(30);
    }

    @Deprecated
    public PagedIterable<GHRepository> listRepositories(int pageSize) {
        return this.listRepositories().withPageSize(pageSize);
    }

    public GHRepository getRepository(String name) throws IOException {
        try {
            return GHRepository.read(this.root(), this.login, name);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public abstract PagedIterable<GHEventInfo> listEvents() throws IOException;

    public String getAvatarUrl() {
        return this.avatar_url;
    }

    public String getLogin() {
        return this.login;
    }

    public String getName() throws IOException {
        this.populate();
        return this.name;
    }

    public String getCompany() throws IOException {
        this.populate();
        return this.company;
    }

    public String getLocation() throws IOException {
        this.populate();
        return this.location;
    }

    public String getTwitterUsername() throws IOException {
        this.populate();
        return this.twitter_username;
    }

    @Override
    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getCreatedAt() throws IOException {
        this.populate();
        return super.getCreatedAt();
    }

    @Override
    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getUpdatedAt() throws IOException {
        this.populate();
        return super.getUpdatedAt();
    }

    public String getBlog() throws IOException {
        this.populate();
        return this.blog;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public String getEmail() throws IOException {
        this.populate();
        return this.email;
    }

    public int getPublicGistCount() throws IOException {
        this.populate();
        return this.public_gists;
    }

    public int getPublicRepoCount() throws IOException {
        this.populate();
        return this.public_repos;
    }

    public int getFollowingCount() throws IOException {
        this.populate();
        return this.following;
    }

    public int getFollowersCount() throws IOException {
        this.populate();
        return this.followers;
    }

    public String getType() throws IOException {
        if (this.type == null) {
            this.populate();
        }
        return this.type;
    }

    public boolean isSiteAdmin() throws IOException {
        this.populate();
        return this.site_admin;
    }

    public Optional<Integer> getTotalPrivateRepoCount() throws IOException {
        this.populate();
        return Optional.ofNullable(this.total_private_repos);
    }
}

