/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GitHubBridgeAdapterObject;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.TrafficInfo;

public abstract class GHRepositoryTraffic
extends GitHubBridgeAdapterObject
implements TrafficInfo {
    private int count;
    private int uniques;

    GHRepositoryTraffic() {
    }

    GHRepositoryTraffic(int count, int uniques) {
        this.count = count;
        this.uniques = uniques;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getUniques() {
        return this.uniques;
    }

    public abstract List<? extends DailyInfo> getDailyInfo();

    @BridgeMethodsAdded
    public static abstract class DailyInfo
    implements TrafficInfo {
        private String timestamp;
        private int count;
        private int uniques;

        @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
        public Instant getTimestamp() {
            return GitHubClient.parseInstant(this.timestamp);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int getUniques() {
            return this.uniques;
        }

        DailyInfo() {
        }

        DailyInfo(String timestamp, Integer count, Integer uniques) {
            this.timestamp = timestamp;
            this.count = count;
            this.uniques = uniques;
        }
    }
}

