/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.connector;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.connector.GitHubConnectorRequest;

public abstract class GitHubConnectorResponse
implements Closeable {
    private static final Comparator<String> nullableCaseInsensitiveComparator = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
    private final int statusCode;
    @Nonnull
    private final GitHubConnectorRequest request;
    @Nonnull
    private final Map<String, List<String>> headers;
    private boolean bodyStreamCalled = false;
    private InputStream bodyStream = null;
    private byte[] bodyBytes = null;
    private boolean isClosed = false;
    private boolean isBodyStreamRereadable;

    protected GitHubConnectorResponse(@Nonnull GitHubConnectorRequest request, int statusCode, @Nonnull Map<String, List<String>> headers) {
        this.request = request;
        this.statusCode = statusCode;
        TreeMap caseInsensitiveMap = new TreeMap(nullableCaseInsensitiveComparator);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            caseInsensitiveMap.put(entry.getKey(), Collections.unmodifiableList(new ArrayList(entry.getValue())));
        }
        this.headers = Collections.unmodifiableMap(caseInsensitiveMap);
        this.isBodyStreamRereadable = false;
    }

    @CheckForNull
    public String header(String name) {
        String result = null;
        if (this.headers.containsKey(name)) {
            result = this.headers.get(name).get(0);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public InputStream bodyStream() throws IOException {
        GitHubConnectorResponse gitHubConnectorResponse = this;
        synchronized (gitHubConnectorResponse) {
            if (this.isClosed) {
                throw new IOException("Response is closed");
            }
            if (this.bodyStreamCalled) {
                if (!this.isBodyStreamRereadable()) {
                    throw new IOException("Response body not rereadable");
                }
            } else {
                this.bodyStream = this.wrapStream(this.rawBodyStream());
                this.bodyStreamCalled = true;
            }
            if (this.bodyStream == null) {
                throw new IOException("Response body missing, stream null");
            }
            if (!this.isBodyStreamRereadable()) {
                return this.bodyStream;
            }
            if (this.bodyBytes == null) {
                this.bodyBytes = IOUtils.toByteArray((InputStream)this.bodyStream);
                IOUtils.closeQuietly((InputStream)this.bodyStream);
            }
            return new ByteArrayInputStream(this.bodyBytes);
        }
    }

    @CheckForNull
    protected abstract InputStream rawBodyStream() throws IOException;

    @Nonnull
    public GitHubConnectorRequest request() {
        return this.request;
    }

    public int statusCode() {
        return this.statusCode;
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Unmodifiable map of unmodifiable lists")
    public Map<String, List<String>> allHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBodyStreamRereadable() {
        GitHubConnectorResponse gitHubConnectorResponse = this;
        synchronized (gitHubConnectorResponse) {
            return this.isBodyStreamRereadable || this.statusCode != 200;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBodyStreamRereadable() {
        GitHubConnectorResponse gitHubConnectorResponse = this;
        synchronized (gitHubConnectorResponse) {
            if (this.bodyStreamCalled && !this.isBodyStreamRereadable()) {
                throw new RuntimeException("bodyStream() already called in read-once mode");
            }
            this.isBodyStreamRereadable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        GitHubConnectorResponse gitHubConnectorResponse = this;
        synchronized (gitHubConnectorResponse) {
            IOUtils.closeQuietly((InputStream)this.bodyStream);
            this.isClosed = true;
            this.bodyBytes = null;
        }
    }

    protected InputStream wrapStream(InputStream stream) throws IOException {
        String encoding = this.header("Content-Encoding");
        if (encoding == null || stream == null) {
            return stream;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(stream);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    public final int parseInt(String name) throws NumberFormatException {
        try {
            String headerValue = this.header(name);
            return Integer.parseInt(headerValue);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(name + ": " + e.getMessage());
        }
    }

    @Deprecated
    public static abstract class ByteArrayResponse
    extends GitHubConnectorResponse {
        protected ByteArrayResponse(@Nonnull GitHubConnectorRequest request, int statusCode, @Nonnull Map<String, List<String>> headers) {
            super(request, statusCode, headers);
        }
    }
}

