/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Requester;
import org.kohsuke.github.function.InputStreamFunction;

@BridgeMethodsAdded
public class GHArtifact
extends GHObject {
    @JsonIgnore
    private GHRepository owner;
    private String name;
    private long sizeInBytes;
    private String archiveDownloadUrl;
    private boolean expired;
    private String expiresAt;

    public String getName() {
        return this.name;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public URL getArchiveDownloadUrl() {
        return GitHubClient.parseURL(this.archiveDownloadUrl);
    }

    public boolean isExpired() {
        return this.expired;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getExpiresAt() {
        return GitHubClient.parseInstant(this.expiresAt);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getRepository() {
        return this.owner;
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    public <T> T download(InputStreamFunction<T> streamFunction) throws IOException {
        Objects.requireNonNull(streamFunction, "Stream function must not be null");
        return ((Requester)((Requester)this.root().createRequest().method("GET")).withUrlPath(this.getApiRoute(), "zip")).fetchStream(streamFunction);
    }

    private String getApiRoute() {
        if (this.owner == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root().getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/actions/artifacts/" + this.getId();
    }

    GHArtifact wrapUp(GHRepository owner) {
        this.owner = owner;
        return this;
    }
}

