/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Requester;

@BridgeMethodsAdded
public class GHDeployKey {
    protected String url;
    protected String key;
    protected String title;
    protected boolean verified;
    protected long id;
    private GHRepository owner;
    private String createdAt;
    private String lastUsed;
    private String addedBy;
    private boolean readOnly;

    public long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isVerified() {
        return this.verified;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getCreatedAt() {
        return GitHubClient.parseInstant(this.createdAt);
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getLastUsedAt() {
        return GitHubClient.parseInstant(this.lastUsed);
    }

    @Deprecated
    public String getAdded_by() {
        return this.getAddedBy();
    }

    public String getAddedBy() {
        return this.addedBy;
    }

    @Deprecated
    public boolean isRead_only() {
        return this.isReadOnly();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    GHDeployKey lateBind(GHRepository repo) {
        this.owner = repo;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("title", (Object)this.title).append("id", this.id).append("key", (Object)this.key).append("created_at", (Object)this.createdAt).append("last_used", (Object)this.lastUsed).append("added_by", (Object)this.addedBy).append("read_only", this.readOnly).toString();
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(String.format("/repos/%s/%s/keys/%d", this.owner.getOwnerName(), this.owner.getName(), this.id), new String[0])).send();
    }
}

