/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHCommentAuthorAssociation;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.EnumUtils;

public class GHIssueComment
extends GHObject
implements Reactable {
    GHIssue owner;
    private String body;
    private String gravatarId;
    private String htmlUrl;
    private String authorAssociation;
    private GHUser user;

    GHIssueComment wrapUp(GHIssue owner) {
        this.owner = owner;
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHIssue getParent() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public GHUser getUser() throws IOException {
        return this.owner == null || this.owner.isOffline() ? this.user : this.owner.root().getUser(this.user.getLogin());
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public GHCommentAuthorAssociation getAuthorAssociation() {
        return EnumUtils.getEnumOrDefault(GHCommentAuthorAssociation.class, this.authorAssociation, GHCommentAuthorAssociation.UNKNOWN);
    }

    public void update(String body) throws IOException {
        ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("PATCH")).with("body", body)).withUrlPath(this.getApiRoute(), new String[0])).fetch(GHIssueComment.class);
        this.body = body;
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    @Override
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).with("content", content.getContent())).withUrlPath(this.getApiRoute() + "/reactions", new String[0])).fetch(GHReaction.class);
    }

    @Override
    public void deleteReaction(GHReaction reaction) throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), "reactions", String.valueOf(reaction.getId()))).send();
    }

    @Override
    public PagedIterable<GHReaction> listReactions() {
        return ((Requester)this.owner.root().createRequest().withUrlPath(this.getApiRoute() + "/reactions", new String[0])).toIterable(GHReaction[].class, item -> this.owner.root());
    }

    private String getApiRoute() {
        return "/repos/" + this.owner.getRepository().getOwnerName() + "/" + this.owner.getRepository().getName() + "/issues/comments/" + this.getId();
    }
}

