/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.internal.EnumUtils;

@BridgeMethodsAdded
public class GHProjectsV2Item
extends GHObject {
    private String projectNodeId;
    private String contentNodeId;
    private String contentType;
    private GHUser creator;
    private String archivedAt;

    public String getProjectNodeId() {
        return this.projectNodeId;
    }

    public String getContentNodeId() {
        return this.contentNodeId;
    }

    public ContentType getContentType() {
        return EnumUtils.getEnumOrDefault(ContentType.class, this.contentType, ContentType.UNKNOWN);
    }

    public GHUser getCreator() {
        return this.root().intern(this.creator);
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getArchivedAt() {
        return GitHubClient.parseInstant(this.archivedAt);
    }

    public URL getHtmlUrl() {
        throw new IllegalStateException(this.getClass().getName() + " does not offer a HTML URL.");
    }

    public static enum ContentType {
        ISSUE,
        DRAFTISSUE,
        PULLREQUEST,
        UNKNOWN;

    }
}

