/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHSubscription;
import org.kohsuke.github.GitHubBridgeAdapterObject;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
@BridgeMethodsAdded
public class GHThread
extends GHObject {
    private GHRepository repository;
    private Subject subject;
    private String reason;
    private boolean unread;
    private String lastReadAt;
    private String url;
    private String subscriptionUrl;

    private GHThread() {
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getLastReadAt() {
        return GitHubClient.parseInstant(this.lastReadAt);
    }

    public String getReason() {
        return this.reason;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getRepository() {
        return this.repository;
    }

    public boolean isRead() {
        return !this.unread;
    }

    public String getTitle() {
        return this.subject.title;
    }

    public String getType() {
        return this.subject.type;
    }

    public String getLastCommentUrl() {
        return this.subject.latestCommentUrl;
    }

    public GHIssue getBoundIssue() throws IOException {
        if (!"Issue".equals(this.subject.type) && "PullRequest".equals(this.subject.type)) {
            return null;
        }
        return this.repository.getIssue(Integer.parseInt(this.subject.url.substring(this.subject.url.lastIndexOf(47) + 1)));
    }

    public GHPullRequest getBoundPullRequest() throws IOException {
        if (!"PullRequest".equals(this.subject.type)) {
            return null;
        }
        return this.repository.getPullRequest(Integer.parseInt(this.subject.url.substring(this.subject.url.lastIndexOf(47) + 1)));
    }

    public GHCommit getBoundCommit() throws IOException {
        if (!"Commit".equals(this.subject.type)) {
            return null;
        }
        return this.repository.getCommit(this.subject.url.substring(this.subject.url.lastIndexOf(47) + 1));
    }

    public void markAsRead() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("PATCH")).withUrlPath(this.url, new String[0])).send();
    }

    public GHSubscription subscribe(boolean subscribed, boolean ignored) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("PUT")).with("subscribed", subscribed)).with("ignored", ignored)).withUrlPath(this.subscriptionUrl, new String[0])).fetch(GHSubscription.class);
    }

    public GHSubscription getSubscription() throws IOException {
        try {
            return ((Requester)((Requester)this.root().createRequest().method("POST")).withUrlPath(this.subscriptionUrl, new String[0])).fetch(GHSubscription.class);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    static class Subject
    extends GitHubBridgeAdapterObject {
        String title;
        String url;
        String latestCommentUrl;
        String type;

        Subject() {
        }
    }
}

