/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Date;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHIssueCommentQueryBuilder {
    private final Requester req;
    private final GHIssue issue;

    GHIssueCommentQueryBuilder(GHIssue issue) {
        this.issue = issue;
        this.req = (Requester)issue.root().createRequest().withUrlPath(issue.getIssuesApiRoute() + "/comments", new String[0]);
    }

    public GHIssueCommentQueryBuilder since(Date date) {
        this.req.with("since", GitHubClient.printDate(date));
        return this;
    }

    public GHIssueCommentQueryBuilder since(long timestamp) {
        return this.since(new Date(timestamp));
    }

    public PagedIterable<GHIssueComment> list() {
        return this.req.toIterable(GHIssueComment[].class, item -> item.wrapUp(this.issue));
    }
}

