/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHCommitPointer;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHPullRequestFileDetail;
import org.kohsuke.github.GHPullRequestReview;
import org.kohsuke.github.GHPullRequestReviewBuilder;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.GHPullRequestReviewState;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Refreshable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.Previews;

public class GHPullRequest
extends GHIssue
implements Refreshable {
    private static final String COMMENTS_ACTION = "/comments";
    private static final String REQUEST_REVIEWERS = "/requested_reviewers";
    private String patch_url;
    private String diff_url;
    private String issue_url;
    private GHCommitPointer base;
    private String merged_at;
    private GHCommitPointer head;
    private GHUser merged_by;
    private int review_comments;
    private int additions;
    private int commits;
    private boolean merged;
    private boolean maintainer_can_modify;
    boolean draft;
    private Boolean mergeable;
    private int deletions;
    private String mergeable_state;
    private int changed_files;
    private String merge_commit_sha;
    private AutoMerge auto_merge;
    private GHUser[] requested_reviewers;
    private GHTeam[] requested_teams;

    GHPullRequest wrapUp(GHRepository owner) {
        this.wrap(owner);
        return this;
    }

    @Override
    protected String getApiRoute() {
        if (this.owner == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root().getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]).replace("/issues/", "/pulls/");
        }
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/pulls/" + this.number;
    }

    public AutoMerge getAutoMerge() {
        return this.auto_merge;
    }

    public URL getPatchUrl() {
        return GitHubClient.parseURL(this.patch_url);
    }

    public URL getIssueUrl() {
        return GitHubClient.parseURL(this.issue_url);
    }

    public GHCommitPointer getBase() {
        return this.base;
    }

    public GHCommitPointer getHead() {
        return this.head;
    }

    @Deprecated
    public Date getIssueUpdatedAt() throws IOException {
        return super.getUpdatedAt();
    }

    public URL getDiffUrl() {
        return GitHubClient.parseURL(this.diff_url);
    }

    public Date getMergedAt() {
        return GitHubClient.parseDate(this.merged_at);
    }

    @Override
    public GHUser getClosedBy() {
        return null;
    }

    @Override
    public GHIssue.PullRequest getPullRequest() {
        return null;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getMergedBy() throws IOException {
        this.populate();
        return this.merged_by;
    }

    public int getReviewComments() throws IOException {
        this.populate();
        return this.review_comments;
    }

    public int getAdditions() throws IOException {
        this.populate();
        return this.additions;
    }

    public int getCommits() throws IOException {
        this.populate();
        return this.commits;
    }

    public boolean isMerged() throws IOException {
        this.populate();
        return this.merged;
    }

    public boolean canMaintainerModify() throws IOException {
        this.populate();
        return this.maintainer_can_modify;
    }

    public boolean isDraft() throws IOException {
        this.populate();
        return this.draft;
    }

    public Boolean getMergeable() throws IOException {
        this.refresh(this.mergeable);
        return this.mergeable;
    }

    @Deprecated
    Boolean getMergeableNoRefresh() throws IOException {
        return this.mergeable;
    }

    public int getDeletions() throws IOException {
        this.populate();
        return this.deletions;
    }

    public String getMergeableState() throws IOException {
        this.populate();
        return this.mergeable_state;
    }

    public int getChangedFiles() throws IOException {
        this.populate();
        return this.changed_files;
    }

    public String getMergeCommitSha() throws IOException {
        this.populate();
        return this.merge_commit_sha;
    }

    public List<GHUser> getRequestedReviewers() throws IOException {
        this.refresh(this.requested_reviewers);
        return Collections.unmodifiableList(Arrays.asList(this.requested_reviewers));
    }

    public List<GHTeam> getRequestedTeams() throws IOException {
        this.refresh(this.requested_teams);
        return Collections.unmodifiableList(Arrays.asList(this.requested_teams));
    }

    private void populate() throws IOException {
        if (this.mergeable_state != null) {
            return;
        }
        this.refresh();
    }

    @Override
    public void refresh() throws IOException {
        if (this.isOffline()) {
            return;
        }
        URL url = this.getUrl();
        if (url != null) {
            ((Requester)((Requester)this.root().createRequest().withPreview(Previews.SHADOW_CAT)).setRawUrlPath(url.toString())).fetchInto(this).wrapUp(this.owner);
        }
    }

    public PagedIterable<GHPullRequestFileDetail> listFiles() {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("%s/files", this.getApiRoute()), new String[0])).toIterable(GHPullRequestFileDetail[].class, null);
    }

    public PagedIterable<GHPullRequestReview> listReviews() {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("%s/reviews", this.getApiRoute()), new String[0])).toIterable(GHPullRequestReview[].class, item -> item.wrapUp(this));
    }

    public PagedIterable<GHPullRequestReviewComment> listReviewComments() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiRoute() + COMMENTS_ACTION, new String[0])).toIterable(GHPullRequestReviewComment[].class, item -> item.wrapUp(this));
    }

    public PagedIterable<GHPullRequestCommitDetail> listCommits() {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("%s/commits", this.getApiRoute()), new String[0])).toIterable(GHPullRequestCommitDetail[].class, item -> item.wrapUp(this));
    }

    @Deprecated
    public GHPullRequestReview createReview(String body, @CheckForNull GHPullRequestReviewState event, GHPullRequestReviewComment ... comments) throws IOException {
        return this.createReview(body, event, Arrays.asList(comments));
    }

    @Deprecated
    public GHPullRequestReview createReview(String body, @CheckForNull GHPullRequestReviewState event, List<GHPullRequestReviewComment> comments) throws IOException {
        GHPullRequestReviewBuilder b = this.createReview().body(body);
        for (GHPullRequestReviewComment c : comments) {
            b.comment(c.getBody(), c.getPath(), c.getPosition());
        }
        return b.create();
    }

    public GHPullRequestReviewBuilder createReview() {
        return new GHPullRequestReviewBuilder(this);
    }

    public GHPullRequestReviewComment createReviewComment(String body, String sha, String path, int position) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("body", body)).with("commit_id", sha)).with("path", path)).with("position", position)).withUrlPath(this.getApiRoute() + COMMENTS_ACTION, new String[0])).fetch(GHPullRequestReviewComment.class).wrapUp(this);
    }

    public void requestReviewers(List<GHUser> reviewers) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("reviewers", GHPullRequest.getLogins(reviewers))).withUrlPath(this.getApiRoute() + REQUEST_REVIEWERS, new String[0])).send();
    }

    public void requestTeamReviewers(List<GHTeam> teams) throws IOException {
        ArrayList<String> teamReviewers = new ArrayList<String>(teams.size());
        for (GHTeam team : teams) {
            teamReviewers.add(team.getSlug());
        }
        ((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("team_reviewers", teamReviewers)).withUrlPath(this.getApiRoute() + REQUEST_REVIEWERS, new String[0])).send();
    }

    public GHPullRequest setBaseBranch(String newBaseBranch) throws IOException {
        return ((Requester)((Requester)((Requester)this.root().createRequest().method("PATCH")).with("base", newBaseBranch)).withUrlPath(this.getApiRoute(), new String[0])).fetch(GHPullRequest.class);
    }

    @Preview(value={Previews.LYDIAN})
    public void updateBranch() throws IOException {
        ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().withPreview(Previews.LYDIAN)).method("PUT")).with("expected_head_sha", this.head.getSha())).withUrlPath(this.getApiRoute() + "/update-branch", new String[0])).send();
    }

    public void merge(String msg) throws IOException {
        this.merge(msg, null);
    }

    public void merge(String msg, String sha) throws IOException {
        this.merge(msg, sha, null);
    }

    public void merge(String msg, String sha, MergeMethod method) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("PUT")).with("commit_message", msg)).with("sha", sha)).with("merge_method", method)).withUrlPath(this.getApiRoute() + "/merge", new String[0])).send();
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
    public static class AutoMerge {
        private GHUser enabled_by;
        private MergeMethod merge_method;
        private String commit_title;
        private String commit_message;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
        public GHUser getEnabledBy() {
            return this.enabled_by;
        }

        public MergeMethod getMergeMethod() {
            return this.merge_method;
        }

        public String getCommitTitle() {
            return this.commit_title;
        }

        public String getCommitMessage() {
            return this.commit_message;
        }
    }

    public static enum MergeMethod {
        MERGE,
        SQUASH,
        REBASE;

    }
}

