/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.GHKey;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHProject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.Previews;

public class GHUser
extends GHPerson {
    protected String ldap_dn;

    public List<GHKey> getKeys() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("keys"), new String[0])).toIterable(GHKey[].class, null).toList();
    }

    public void follow() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("PUT")).withUrlPath("/user/following/" + this.login, new String[0])).send();
    }

    public void unfollow() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath("/user/following/" + this.login, new String[0])).send();
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getFollows() throws IOException {
        return new GHPersonSet<GHUser>((Collection<GHUser>)this.listFollows().toList());
    }

    public PagedIterable<GHUser> listFollows() {
        return this.listUser("following");
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getFollowers() throws IOException {
        return new GHPersonSet<GHUser>((Collection<GHUser>)this.listFollowers().toList());
    }

    public PagedIterable<GHUser> listFollowers() {
        return this.listUser("followers");
    }

    private PagedIterable<GHUser> listUser(String suffix) {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl(suffix), new String[0])).toIterable(GHUser[].class, null);
    }

    public PagedIterable<GHRepository> listSubscriptions() {
        return this.listRepositories("subscriptions");
    }

    public PagedIterable<GHRepository> listStarredRepositories() {
        return this.listRepositories("starred");
    }

    @Preview(value={Previews.INERTIA})
    public PagedIterable<GHProject> listProjects() {
        return ((Requester)((Requester)this.root().createRequest().withPreview(Previews.INERTIA)).withUrlPath(this.getApiTailUrl("projects"), new String[0])).toIterable(GHProject[].class, null);
    }

    private PagedIterable<GHRepository> listRepositories(String suffix) {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl(suffix), new String[0])).toIterable(GHRepository[].class, null);
    }

    public boolean isMemberOf(GHOrganization org) {
        return org.hasMember(this);
    }

    public boolean isMemberOf(GHTeam team) {
        return team.hasMember(this);
    }

    public boolean isPublicMemberOf(GHOrganization org) {
        return org.hasPublicMember(this);
    }

    public boolean isHireable() {
        return this.hireable;
    }

    public String getBio() {
        return this.bio;
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHOrganization> getOrganizations() throws IOException {
        GHPersonSet<GHOrganization> orgs = new GHPersonSet<GHOrganization>();
        HashSet<String> names = new HashSet<String>();
        for (GHOrganization o : (GHOrganization[])((Requester)this.root().createRequest().withUrlPath("/users/" + this.login + "/orgs", new String[0])).toIterable(GHOrganization[].class, null).toArray()) {
            if (!names.add(o.getLogin())) continue;
            orgs.add(this.root().getOrganization(o.getLogin()));
        }
        return orgs;
    }

    @Override
    public PagedIterable<GHEventInfo> listEvents() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/users/%s/events", this.login), new String[0])).toIterable(GHEventInfo[].class, null);
    }

    public PagedIterable<GHGist> listGists() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/users/%s/gists", this.login), new String[0])).toIterable(GHGist[].class, null);
    }

    public Optional<String> getLdapDn() throws IOException {
        super.populate();
        return Optional.ofNullable(this.ldap_dn);
    }

    public int hashCode() {
        return this.login.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHUser) {
            GHUser that = (GHUser)obj;
            return this.login.equals(that.login);
        }
        return false;
    }

    String getApiTailUrl(String tail) {
        if (tail.length() > 0 && !tail.startsWith("/")) {
            tail = '/' + tail;
        }
        return "/users/" + this.login + tail;
    }
}

