/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.github.BetaApi;
import org.kohsuke.github.GHApp;
import org.kohsuke.github.GHAppFromManifest;
import org.kohsuke.github.GHAuthenticatedAppInstallation;
import org.kohsuke.github.GHAuthorization;
import org.kohsuke.github.GHCommitSearchBuilder;
import org.kohsuke.github.GHContentSearchBuilder;
import org.kohsuke.github.GHCreateRepositoryBuilder;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.GHGistBuilder;
import org.kohsuke.github.GHInvitation;
import org.kohsuke.github.GHIssueSearchBuilder;
import org.kohsuke.github.GHLicense;
import org.kohsuke.github.GHMarketplacePlan;
import org.kohsuke.github.GHMarketplaceUserPurchase;
import org.kohsuke.github.GHMeta;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHNotificationStream;
import org.kohsuke.github.GHOTPRequiredException;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHProject;
import org.kohsuke.github.GHProjectCard;
import org.kohsuke.github.GHProjectColumn;
import org.kohsuke.github.GHPullRequestSearchBuilder;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositorySearchBuilder;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHUserSearchBuilder;
import org.kohsuke.github.GitHubAbuseLimitHandler;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRateLimitChecker;
import org.kohsuke.github.GitHubRateLimitHandler;
import org.kohsuke.github.GitHubSanityCachedValue;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.RateLimitTarget;
import org.kohsuke.github.Requester;
import org.kohsuke.github.authorization.AuthorizationProvider;
import org.kohsuke.github.authorization.ImmutableAuthorizationProvider;
import org.kohsuke.github.authorization.UserAuthorizationProvider;
import org.kohsuke.github.connector.GitHubConnector;
import org.kohsuke.github.internal.GitHubConnectorHttpConnectorAdapter;
import org.kohsuke.github.internal.Previews;

public class GitHub {
    @Nonnull
    private final GitHubClient client;
    @CheckForNull
    private GHMyself myself;
    private final ConcurrentMap<String, GHUser> users;
    private final ConcurrentMap<String, GHOrganization> orgs;
    @Nonnull
    private final GitHubSanityCachedValue<GHMeta> sanityCachedMeta = new GitHubSanityCachedValue();
    private static final Logger LOGGER = Logger.getLogger(GitHub.class.getName());

    GitHub(String apiUrl, GitHubConnector connector, GitHubRateLimitHandler rateLimitHandler, GitHubAbuseLimitHandler abuseLimitHandler, GitHubRateLimitChecker rateLimitChecker, AuthorizationProvider authorizationProvider) throws IOException {
        UserAuthorizationProvider provider;
        if (authorizationProvider instanceof DependentAuthorizationProvider) {
            ((DependentAuthorizationProvider)authorizationProvider).bind(this);
        } else if (authorizationProvider instanceof ImmutableAuthorizationProvider && authorizationProvider instanceof UserAuthorizationProvider && (provider = (UserAuthorizationProvider)authorizationProvider).getLogin() == null && provider.getEncodedAuthorization() != null && provider.getEncodedAuthorization().startsWith("token")) {
            authorizationProvider = new LoginLoadingUserAuthorizationProvider(provider, this);
        }
        this.users = new ConcurrentHashMap<String, GHUser>();
        this.orgs = new ConcurrentHashMap<String, GHOrganization>();
        this.client = new GitHubClient(apiUrl, connector, rateLimitHandler, abuseLimitHandler, rateLimitChecker, authorizationProvider);
        if (authorizationProvider instanceof LoginLoadingUserAuthorizationProvider) {
            ((LoginLoadingUserAuthorizationProvider)authorizationProvider).getLogin();
        }
    }

    private GitHub(GitHubClient client) {
        this.users = new ConcurrentHashMap<String, GHUser>();
        this.orgs = new ConcurrentHashMap<String, GHOrganization>();
        this.client = client;
    }

    public static GitHub connect() throws IOException {
        return GitHubBuilder.fromCredentials().build();
    }

    @Deprecated
    public static GitHub connectToEnterprise(String apiUrl, String oauthAccessToken) throws IOException {
        return GitHub.connectToEnterpriseWithOAuth(apiUrl, null, oauthAccessToken);
    }

    public static GitHub connectToEnterpriseWithOAuth(String apiUrl, String login, String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withEndpoint(apiUrl).withOAuthToken(oauthAccessToken, login).build();
    }

    @Deprecated
    public static GitHub connectToEnterprise(String apiUrl, String login, String password) throws IOException {
        return new GitHubBuilder().withEndpoint(apiUrl).withPassword(login, password).build();
    }

    public static GitHub connect(String login, String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withOAuthToken(oauthAccessToken, login).build();
    }

    @Deprecated
    public static GitHub connect(String login, String oauthAccessToken, String password) throws IOException {
        return new GitHubBuilder().withOAuthToken(oauthAccessToken, login).withPassword(login, password).build();
    }

    @Deprecated
    public static GitHub connectUsingPassword(String login, String password) throws IOException {
        return new GitHubBuilder().withPassword(login, password).build();
    }

    public static GitHub connectUsingOAuth(String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withOAuthToken(oauthAccessToken).build();
    }

    public static GitHub connectUsingOAuth(String githubServer, String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withEndpoint(githubServer).withOAuthToken(oauthAccessToken).build();
    }

    public static GitHub connectAnonymously() throws IOException {
        return new GitHubBuilder().build();
    }

    public static GitHub connectToEnterpriseAnonymously(String apiUrl) throws IOException {
        return new GitHubBuilder().withEndpoint(apiUrl).build();
    }

    public static GitHub offline() {
        try {
            return new GitHubBuilder().withEndpoint("https://api.github.invalid").withConnector(GitHubConnector.OFFLINE).build();
        }
        catch (IOException e) {
            throw new IllegalStateException("The offline implementation constructor should not connect", e);
        }
    }

    public boolean isAnonymous() {
        return this.client.isAnonymous();
    }

    public boolean isOffline() {
        return this.client.isOffline();
    }

    @Deprecated
    public HttpConnector getConnector() {
        return this.client.getConnector();
    }

    @Deprecated
    public void setConnector(@Nonnull HttpConnector connector) {
        this.client.setConnector(GitHubConnectorHttpConnectorAdapter.adapt(connector));
    }

    public String getApiUrl() {
        return this.client.getApiUrl();
    }

    @Nonnull
    public GHRateLimit getRateLimit() throws IOException {
        return this.client.getRateLimit();
    }

    @Nonnull
    @Deprecated
    public GHRateLimit lastRateLimit() {
        return this.client.lastRateLimit();
    }

    @Nonnull
    @Deprecated
    public GHRateLimit rateLimit() throws IOException {
        return this.client.rateLimit(RateLimitTarget.CORE);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    @WithBridgeMethods(value={GHUser.class})
    public GHMyself getMyself() throws IOException {
        this.client.requireCredential();
        return this.setMyself();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GHMyself setMyself() throws IOException {
        GitHub gitHub = this;
        synchronized (gitHub) {
            if (this.myself == null) {
                this.myself = ((Requester)this.createRequest().withUrlPath("/user", new String[0])).fetch(GHMyself.class);
            }
            return this.myself;
        }
    }

    public GHUser getUser(String login) throws IOException {
        GHUser u = (GHUser)this.users.get(login);
        if (u == null) {
            u = ((Requester)this.createRequest().withUrlPath("/users/" + login, new String[0])).fetch(GHUser.class);
            this.users.put(u.getLogin(), u);
        }
        return u;
    }

    public void refreshCache() {
        this.users.clear();
        this.orgs.clear();
    }

    protected GHUser getUser(GHUser orig) {
        GHUser u = (GHUser)this.users.get(orig.getLogin());
        if (u == null) {
            this.users.put(orig.getLogin(), orig);
            return orig;
        }
        return u;
    }

    public GHOrganization getOrganization(String name) throws IOException {
        GHOrganization o = (GHOrganization)this.orgs.get(name);
        if (o == null) {
            o = ((Requester)this.createRequest().withUrlPath("/orgs/" + name, new String[0])).fetch(GHOrganization.class);
            this.orgs.put(name, o);
        }
        return o;
    }

    public PagedIterable<GHOrganization> listOrganizations() {
        return this.listOrganizations(null);
    }

    public PagedIterable<GHOrganization> listOrganizations(String since) {
        return ((Requester)((Requester)this.createRequest().with("since", since)).withUrlPath("/organizations", new String[0])).toIterable(GHOrganization[].class, null);
    }

    public GHRepository getRepository(String name) throws IOException {
        String[] tokens = name.split("/");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Repository name must be in format owner/repo");
        }
        return GHRepository.read(this, tokens[0], tokens[1]);
    }

    @Deprecated
    public GHRepository getRepositoryById(String id) throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/repositories/" + id, new String[0])).fetch(GHRepository.class);
    }

    public GHRepository getRepositoryById(long id) throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/repositories/" + id, new String[0])).fetch(GHRepository.class);
    }

    public PagedIterable<GHLicense> listLicenses() throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/licenses", new String[0])).toIterable(GHLicense[].class, null);
    }

    public PagedIterable<GHUser> listUsers() throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/users", new String[0])).toIterable(GHUser[].class, null);
    }

    public GHLicense getLicense(String key) throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/licenses/" + key, new String[0])).fetch(GHLicense.class);
    }

    public PagedIterable<GHMarketplacePlan> listMarketplacePlans() throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/marketplace_listing/plans", new String[0])).toIterable(GHMarketplacePlan[].class, null);
    }

    public List<GHInvitation> getMyInvitations() throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/user/repository_invitations", new String[0])).toIterable(GHInvitation[].class, null).toList();
    }

    public Map<String, GHOrganization> getMyOrganizations() throws IOException {
        GHOrganization[] orgs = (GHOrganization[])((Requester)this.createRequest().withUrlPath("/user/orgs", new String[0])).toIterable(GHOrganization[].class, null).toArray();
        HashMap<String, GHOrganization> r = new HashMap<String, GHOrganization>();
        for (GHOrganization o : orgs) {
            r.put(o.getLogin(), o);
        }
        return r;
    }

    public PagedIterable<GHMarketplaceUserPurchase> getMyMarketplacePurchases() throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/user/marketplace_purchases", new String[0])).toIterable(GHMarketplaceUserPurchase[].class, null);
    }

    public Map<String, GHOrganization> getUserPublicOrganizations(GHUser user) throws IOException {
        return this.getUserPublicOrganizations(user.getLogin());
    }

    public Map<String, GHOrganization> getUserPublicOrganizations(String login) throws IOException {
        GHOrganization[] orgs = (GHOrganization[])((Requester)this.createRequest().withUrlPath("/users/" + login + "/orgs", new String[0])).toIterable(GHOrganization[].class, null).toArray();
        HashMap<String, GHOrganization> r = new HashMap<String, GHOrganization>();
        for (GHOrganization o : orgs) {
            r.put(o.getLogin(), o);
        }
        return r;
    }

    public Map<String, Set<GHTeam>> getMyTeams() throws IOException {
        HashMap<String, Set<GHTeam>> allMyTeams = new HashMap<String, Set<GHTeam>>();
        for (GHTeam team : ((Requester)this.createRequest().withUrlPath("/user/teams", new String[0])).toIterable(GHTeam[].class, item -> item.wrapUp(this)).toArray()) {
            String orgLogin = team.getOrganization().getLogin();
            HashSet<GHTeam> teamsPerOrg = (HashSet<GHTeam>)allMyTeams.get(orgLogin);
            if (teamsPerOrg == null) {
                teamsPerOrg = new HashSet<GHTeam>();
            }
            teamsPerOrg.add(team);
            allMyTeams.put(orgLogin, teamsPerOrg);
        }
        return allMyTeams;
    }

    @Deprecated
    public GHTeam getTeam(int id) throws IOException {
        throw new UnsupportedOperationException("This method is not supported anymore. Please use GHOrganization#getTeam(long).");
    }

    public List<GHEventInfo> getEvents() throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/events", new String[0])).toIterable(GHEventInfo[].class, null).toList();
    }

    public List<GHEventInfo> getUserPublicEvents(String login) throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/users/" + login + "/events/public", new String[0])).toIterable(GHEventInfo[].class, null).toList();
    }

    public GHGist getGist(String id) throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/gists/" + id, new String[0])).fetch(GHGist.class);
    }

    public GHGistBuilder createGist() {
        return new GHGistBuilder(this);
    }

    public <T extends GHEventPayload> T parseEventPayload(Reader r, Class<T> type) throws IOException {
        GHEventPayload t = (GHEventPayload)GitHubClient.getMappingObjectReader(this).forType(type).readValue(r);
        t.lateBind();
        return (T)t;
    }

    @Deprecated
    public GHRepository createRepository(String name, String description, String homepage, boolean isPublic) throws IOException {
        return ((GHCreateRepositoryBuilder)((GHCreateRepositoryBuilder)((GHCreateRepositoryBuilder)this.createRepository(name).description(description)).homepage(homepage)).private_(!isPublic)).create();
    }

    public GHCreateRepositoryBuilder createRepository(String name) {
        return new GHCreateRepositoryBuilder(name, this, "/user/repos");
    }

    public GHAuthorization createToken(Collection<String> scope, String note, String noteUrl) throws IOException {
        Requester requester = (Requester)((Requester)((Requester)this.createRequest().with("scopes", scope)).with("note", note)).with("note_url", noteUrl);
        return ((Requester)((Requester)requester.method("POST")).withUrlPath("/authorizations", new String[0])).fetch(GHAuthorization.class);
    }

    public GHAuthorization createToken(Collection<String> scope, String note, String noteUrl, Supplier<String> OTP) throws IOException {
        try {
            return this.createToken(scope, note, noteUrl);
        }
        catch (GHOTPRequiredException ex) {
            String OTPstring = OTP.get();
            Requester requester = (Requester)((Requester)((Requester)this.createRequest().with("scopes", scope)).with("note", note)).with("note_url", noteUrl);
            requester.setHeader("x-github-otp", OTPstring);
            return ((Requester)((Requester)requester.method("POST")).withUrlPath("/authorizations", new String[0])).fetch(GHAuthorization.class);
        }
    }

    public GHAuthorization createOrGetAuth(String clientId, String clientSecret, List<String> scopes, String note, String note_url) throws IOException {
        Requester requester = (Requester)((Requester)((Requester)((Requester)this.createRequest().with("client_secret", clientSecret)).with("scopes", scopes)).with("note", note)).with("note_url", note_url);
        return ((Requester)((Requester)requester.method("PUT")).withUrlPath("/authorizations/clients/" + clientId, new String[0])).fetch(GHAuthorization.class);
    }

    public void deleteAuth(long id) throws IOException {
        ((Requester)((Requester)this.createRequest().method("DELETE")).withUrlPath("/authorizations/" + id, new String[0])).send();
    }

    public GHAuthorization checkAuth(@Nonnull String clientId, @Nonnull String accessToken) throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/applications/" + clientId + "/tokens/" + accessToken, new String[0])).fetch(GHAuthorization.class);
    }

    public GHAuthorization resetAuth(@Nonnull String clientId, @Nonnull String accessToken) throws IOException {
        return ((Requester)((Requester)this.createRequest().method("POST")).withUrlPath("/applications/" + clientId + "/tokens/" + accessToken, new String[0])).fetch(GHAuthorization.class);
    }

    public PagedIterable<GHAuthorization> listMyAuthorizations() throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/authorizations", new String[0])).toIterable(GHAuthorization[].class, null);
    }

    @Preview(value={Previews.MACHINE_MAN})
    public GHApp getApp() throws IOException {
        return ((Requester)((Requester)this.createRequest().withPreview(Previews.MACHINE_MAN)).withUrlPath("/app", new String[0])).fetch(GHApp.class);
    }

    public GHApp getApp(@Nonnull String slug) throws IOException {
        return ((Requester)this.createRequest().withUrlPath("/apps/" + slug, new String[0])).fetch(GHApp.class);
    }

    public GHAppFromManifest createAppFromManifest(@Nonnull String code) throws IOException {
        return ((Requester)((Requester)this.createRequest().method("POST")).withUrlPath("/app-manifests/" + code + "/conversions", new String[0])).fetch(GHAppFromManifest.class);
    }

    @Preview(value={Previews.MACHINE_MAN})
    public GHAuthenticatedAppInstallation getInstallation() throws IOException {
        return new GHAuthenticatedAppInstallation(this);
    }

    public boolean isCredentialValid() {
        return this.client.isCredentialValid();
    }

    public GHMeta getMeta() throws IOException {
        return this.sanityCachedMeta.get(() -> ((Requester)this.createRequest().withUrlPath("/meta", new String[0])).fetch(GHMeta.class));
    }

    public GHProject getProject(long id) throws IOException {
        return ((Requester)((Requester)this.createRequest().withPreview(Previews.INERTIA)).withUrlPath("/projects/" + id, new String[0])).fetch(GHProject.class);
    }

    public GHProjectColumn getProjectColumn(long id) throws IOException {
        return ((Requester)((Requester)this.createRequest().withPreview(Previews.INERTIA)).withUrlPath("/projects/columns/" + id, new String[0])).fetch(GHProjectColumn.class).lateBind(this);
    }

    public GHProjectCard getProjectCard(long id) throws IOException {
        return ((Requester)((Requester)this.createRequest().withPreview(Previews.INERTIA)).withUrlPath("/projects/columns/cards/" + id, new String[0])).fetch(GHProjectCard.class).lateBind(this);
    }

    public void checkApiUrlValidity() throws IOException {
        this.client.checkApiUrlValidity();
    }

    @Preview(value={Previews.CLOAK})
    public GHCommitSearchBuilder searchCommits() {
        return new GHCommitSearchBuilder(this);
    }

    public GHIssueSearchBuilder searchIssues() {
        return new GHIssueSearchBuilder(this);
    }

    public GHPullRequestSearchBuilder searchPullRequests() {
        return new GHPullRequestSearchBuilder(this);
    }

    public GHUserSearchBuilder searchUsers() {
        return new GHUserSearchBuilder(this);
    }

    public GHRepositorySearchBuilder searchRepositories() {
        return new GHRepositorySearchBuilder(this);
    }

    public GHContentSearchBuilder searchContent() {
        return new GHContentSearchBuilder(this);
    }

    public GHNotificationStream listNotifications() {
        return new GHNotificationStream(this, "/notifications");
    }

    public PagedIterable<GHRepository> listAllPublicRepositories() {
        return this.listAllPublicRepositories(null);
    }

    public PagedIterable<GHRepository> listAllPublicRepositories(String since) {
        return ((Requester)((Requester)this.createRequest().with("since", since)).withUrlPath("/repositories", new String[0])).toIterable(GHRepository[].class, null);
    }

    public Reader renderMarkdown(String text) throws IOException {
        return new InputStreamReader((InputStream)((Requester)((Requester)((Requester)((Requester)this.createRequest().method("POST")).with(new ByteArrayInputStream(text.getBytes("UTF-8")))).contentType("text/plain;charset=UTF-8")).withUrlPath("/markdown/raw", new String[0])).fetchStream(Requester::copyInputStream), "UTF-8");
    }

    @Nonnull
    public static ObjectWriter getMappingObjectWriter() {
        return GitHubClient.getMappingObjectWriter();
    }

    @Nonnull
    public static ObjectReader getMappingObjectReader() {
        return GitHubClient.getMappingObjectReader(GitHub.offline());
    }

    @Nonnull
    GitHubClient getClient() {
        return this.client;
    }

    @Nonnull
    Requester createRequest() {
        Requester requester = new Requester(this.client);
        requester.injectMappingValue(this);
        if (!this.getClass().equals(GitHub.class)) {
            requester.injectMappingValue(GitHub.class.getName(), this);
        }
        return requester;
    }

    GHUser intern(GHUser user) throws IOException {
        GHUser existingUser;
        if (user != null && (existingUser = this.users.putIfAbsent(user.getLogin(), user)) != null) {
            user = existingUser;
        }
        return user;
    }

    public static abstract class DependentAuthorizationProvider
    implements AuthorizationProvider {
        private GitHub baseGitHub;
        private GitHub gitHub;
        private final AuthorizationProvider authorizationProvider;

        @BetaApi
        protected DependentAuthorizationProvider(AuthorizationProvider authorizationProvider) {
            this.authorizationProvider = authorizationProvider;
        }

        synchronized void bind(GitHub github) {
            if (this.baseGitHub != null) {
                throw new IllegalStateException("Already bound to another GitHub instance.");
            }
            this.baseGitHub = github;
        }

        protected final synchronized GitHub gitHub() {
            if (this.gitHub == null) {
                this.gitHub = new AuthorizationRefreshGitHubWrapper(this.baseGitHub, this.authorizationProvider);
            }
            return this.gitHub;
        }
    }

    private static class LoginLoadingUserAuthorizationProvider
    implements UserAuthorizationProvider {
        private final GitHub gitHub;
        private final AuthorizationProvider authorizationProvider;
        private boolean loginLoaded = false;
        private String login;

        LoginLoadingUserAuthorizationProvider(AuthorizationProvider authorizationProvider, GitHub gitHub) {
            this.gitHub = gitHub;
            this.authorizationProvider = authorizationProvider;
        }

        @Override
        public String getEncodedAuthorization() throws IOException {
            return this.authorizationProvider.getEncodedAuthorization();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getLogin() {
            LoginLoadingUserAuthorizationProvider loginLoadingUserAuthorizationProvider = this;
            synchronized (loginLoadingUserAuthorizationProvider) {
                if (!this.loginLoaded) {
                    this.loginLoaded = true;
                    try {
                        GHMyself u = this.gitHub.setMyself();
                        if (u != null) {
                            this.login = u.getLogin();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return this.login;
            }
        }
    }

    private static class AuthorizationRefreshGitHubWrapper
    extends GitHub {
        private final AuthorizationProvider authorizationProvider;

        AuthorizationRefreshGitHubWrapper(GitHub github, AuthorizationProvider authorizationProvider) {
            super(github.client);
            this.authorizationProvider = authorizationProvider;
            if (authorizationProvider instanceof DependentAuthorizationProvider) {
                ((DependentAuthorizationProvider)authorizationProvider).bind(this);
            }
        }

        @Override
        @Nonnull
        Requester createRequest() {
            try {
                return (Requester)((Requester)super.createRequest().setHeader("Authorization", this.authorizationProvider.getEncodedAuthorization())).rateLimit(RateLimitTarget.NONE);
            }
            catch (IOException e) {
                throw new GHException("Failed to create requester to refresh credentials", e);
            }
        }
    }
}

